/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.attach;

import co.elastic.apm.agent.common.util.ProcessExecutionUtil;
import co.elastic.apm.attach.GetAgentProperties;
import co.elastic.apm.attach.JvmInfo;
import co.elastic.apm.attach.UserRegistry;
import com.sun.jna.Platform;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface JvmDiscoverer {
    public Collection<JvmInfo> discoverJvms() throws Exception;

    public boolean isAvailable();

    public static class UsingPs
    implements JvmDiscoverer {
        private static final Logger logger = LogManager.getLogger(UsingPs.class);
        private final UserRegistry userRegistry;

        UsingPs(UserRegistry userRegistry) {
            this.userRegistry = userRegistry;
        }

        @Override
        public Collection<JvmInfo> discoverJvms() throws Exception {
            ArrayList<JvmInfo> jvms = new ArrayList<JvmInfo>();
            ProcessBuilder builder = Platform.isWindows() ? new ProcessBuilder("tasklist", "/FO", "CSV", "/V") : new ProcessBuilder("ps", "aux");
            builder.redirectErrorStream(true);
            Process process = builder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = reader.readLine();
            while (line != null) {
                block4: {
                    String user;
                    String pid;
                    block6: {
                        String[] rows;
                        block5: {
                            if (!line.contains("java")) break block4;
                            if (!Platform.isWindows()) break block5;
                            rows = line.split("\",\"");
                            pid = rows[1];
                            user = rows[6];
                            if (user.contains("\\")) {
                                user = user.substring(user.lastIndexOf(92) + 1);
                            }
                            if (rows[0].startsWith("\"java")) break block6;
                            break block4;
                        }
                        rows = line.split("\\s+");
                        pid = rows[1];
                        user = rows[0];
                    }
                    try {
                        jvms.add(JvmInfo.of(pid, user, GetAgentProperties.getAgentAndSystemProperties(pid, this.userRegistry.get(user))));
                    }
                    catch (Exception e) {
                        logger.debug("Although the process listing output contains 'java', the process {} does not seem to be a Java process.", (Object)pid);
                        logger.debug(line);
                        logger.debug(e.getMessage(), (Throwable)e);
                    }
                }
                line = reader.readLine();
            }
            process.waitFor();
            return jvms;
        }

        @Override
        public boolean isAvailable() {
            try {
                if (Platform.isWindows()) {
                    return JvmInfo.isJ9();
                }
                ArrayList<String> args = new ArrayList<String>();
                args.add("ps");
                args.add("aux");
                return JvmInfo.isJ9() && ProcessExecutionUtil.executeCommand(args).exitedNormally();
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                return false;
            }
        }
    }

    public static class ForHotSpotVm
    implements JvmDiscoverer {
        private static final Logger logger = LogManager.getLogger(ForHotSpotVm.class);
        private final List<String> tempDirs;
        private final UserRegistry userRegistry;

        public ForHotSpotVm(List<String> tempDirs, UserRegistry userRegistry) {
            this.tempDirs = tempDirs;
            this.userRegistry = userRegistry;
        }

        public static ForHotSpotVm withDiscoveredTempDirs(UserRegistry userRegistry) {
            ArrayList<String> tempDirs = new ArrayList<String>();
            if (Platform.isMac()) {
                try {
                    tempDirs.addAll(UserRegistry.getAllUsersMacOs().getAllTempDirs());
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            } else {
                tempDirs.add(System.getProperty("java.io.tmpdir"));
            }
            return new ForHotSpotVm(tempDirs, userRegistry);
        }

        @Override
        public Collection<JvmInfo> discoverJvms() {
            ArrayList<JvmInfo> result = new ArrayList<JvmInfo>();
            List<File> hsPerfdataFolders = this.getHsPerfdataFolders();
            logger.debug("Looking in the following folders for hsperfdata_<user>/<pid> files: {}", (Object)hsPerfdataFolders);
            for (File hsPerfdataFolder : hsPerfdataFolders) {
                File[] jvmPidFiles = hsPerfdataFolder.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file.isFile() && file.canRead() && file.getName().matches("\\d+");
                    }
                });
                if (jvmPidFiles == null) continue;
                for (File jvmPidFile : jvmPidFiles) {
                    String user = jvmPidFile.getParentFile().getName().substring("hsperfdata_".length());
                    try {
                        Properties properties = GetAgentProperties.getAgentAndSystemProperties(jvmPidFile.getName(), this.userRegistry.get(user));
                        result.add(JvmInfo.of(jvmPidFile.getName(), user, properties));
                    }
                    catch (Exception e) {
                        logger.warn("Unable to get properties from {}", (Object)jvmPidFile.getName());
                        logger.warn(e.getMessage(), (Throwable)e);
                    }
                }
            }
            return result;
        }

        @Override
        public boolean isAvailable() {
            return !JvmInfo.isJ9() && !this.getHsPerfdataFolders().isEmpty();
        }

        private List<File> getHsPerfdataFolders() {
            ArrayList<File> result = new ArrayList<File>();
            for (String tempDir : this.tempDirs) {
                File[] files = new File(tempDir).listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.startsWith("hsperfdata_");
                    }
                });
                if (files == null) continue;
                result.addAll(Arrays.asList(files));
            }
            return result;
        }
    }

    public static class Compound
    implements JvmDiscoverer {
        private final List<JvmDiscoverer> jvmDiscoverers;

        public Compound(List<JvmDiscoverer> jvmDiscoverers) {
            this.jvmDiscoverers = jvmDiscoverers;
        }

        @Override
        public Collection<JvmInfo> discoverJvms() throws Exception {
            for (JvmDiscoverer jvmDiscoverer : this.jvmDiscoverers) {
                if (!jvmDiscoverer.isAvailable()) continue;
                return jvmDiscoverer.discoverJvms();
            }
            throw new IllegalStateException("No jvm discoverer is available");
        }

        @Override
        public boolean isAvailable() {
            for (JvmDiscoverer jvmDiscoverer : this.jvmDiscoverers) {
                if (!jvmDiscoverer.isAvailable()) continue;
                return true;
            }
            return false;
        }
    }
}

