/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.health;

import com.fasterxml.jackson.annotation.JsonValue;

public enum Status {
    GREEN("healthy"),
    UNKNOWN("unknown"),
    YELLOW("concerning"),
    RED("unhealthy");

    private final String externalValue = this.name().toLowerCase();
    private final String descriptiveValue;

    private Status(String descriptiveValue) {
        this.descriptiveValue = descriptiveValue;
    }

    @JsonValue
    public String externalValue() {
        return this.externalValue;
    }

    public String descriptiveValue() {
        return this.descriptiveValue;
    }

    public Status reduce(Status status) {
        if (this.compareTo(status) >= 0) {
            return this;
        }
        return status;
    }

    public static class Holder {
        private Status status = GREEN;

        public synchronized Status reduce(Status status) {
            this.status = this.status.reduce(status);
            return this.status;
        }

        public synchronized Status value() {
            return this.status;
        }
    }
}

