"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmptyMigrationRulesPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _deeplinksSecurity = require("@kbn/deeplinks-security");
var _react2 = require("@emotion/react");
var _links = require("../../../common/components/links");
var i18n = _interopRequireWildcard(require("./translations"));
var _constants = require("../../../onboarding/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EmptyMigrationRulesPage = () => {
  return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
    color: "plain",
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: (0, _react2.css)`
          /**
          * 240px compensates for the kibana header, action bar and page header.
          * It also compensates for the extra margin that header introduces
          */
          min-height: calc(100vh - 240px);
        `,
    justifyContent: "center",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    title: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "siemMigrationsTranslatedRulesEmptyPageHeader"
    }, i18n.TRANSLATED_RULES_EMPTY_PAGE_TITLE),
    actions: /*#__PURE__*/_react.default.createElement(_links.SecuritySolutionLinkButton, {
      deepLinkId: _deeplinksSecurity.SecurityPageName.landing,
      path: `${_constants.OnboardingTopicId.siemMigrations}#${_constants.OnboardingCardId.siemMigrationsRules}`
    }, i18n.TRANSLATED_RULES_EMPTY_PAGE_CTA),
    iconType: 'logoSecurity',
    body: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "siemMigrationsTranslatedRulesEmptyPageMessage"
    }, i18n.TRANSLATED_RULES_EMPTY_PAGE_MESSAGE)
  }))));
};
exports.EmptyMigrationRulesPage = EmptyMigrationRulesPage;