"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInstallMigrationRule = exports.INSTALL_MIGRATION_RULE_MUTATION_KEY = void 0;
var _reactQuery = require("@kbn/react-query");
var _react = require("react");
var _kibana_react = require("../../../common/lib/kibana/kibana_react");
var _constants = require("../../../../common/siem_migrations/constants");
var _use_app_toasts = require("../../../common/hooks/use_app_toasts");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_get_migration_rules = require("./use_get_migration_rules");
var _use_get_migration_translation_stats = require("./use_get_migration_translation_stats");
var _api = require("../api");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INSTALL_MIGRATION_RULE_MUTATION_KEY = exports.INSTALL_MIGRATION_RULE_MUTATION_KEY = ['POST', _constants.SIEM_RULE_MIGRATION_INSTALL_PATH];
const useInstallMigrationRule = migrationId => {
  const {
    addError,
    addSuccess
  } = (0, _use_app_toasts.useAppToasts)();
  const {
    telemetry
  } = (0, _kibana_react.useKibana)().services.siemMigrations.rules;
  const reportTelemetry = (0, _react.useCallback)(({
    migrationRule,
    enabled = false
  }, error) => {
    telemetry.reportTranslatedRuleInstall({
      migrationRule,
      enabled,
      error
    });
  }, [telemetry]);
  const invalidateGetRuleMigrations = (0, _use_get_migration_rules.useInvalidateGetMigrationRules)();
  const invalidateGetMigrationTranslationStats = (0, _use_get_migration_translation_stats.useInvalidateGetMigrationTranslationStats)();
  return (0, _reactQuery.useMutation)(({
    migrationRule: ruleMigration,
    enabled
  }) => (0, _api.installMigrationRules)({
    migrationId,
    ids: [ruleMigration.id],
    enabled
  }), {
    mutationKey: INSTALL_MIGRATION_RULE_MUTATION_KEY,
    onSuccess: ({
      installed
    }, variables) => {
      addSuccess(i18n.INSTALL_MIGRATION_RULES_SUCCESS(installed));
      reportTelemetry(variables);
    },
    onError: (error, variables) => {
      addError(error, {
        title: i18n.INSTALL_MIGRATION_RULES_FAILURE
      });
      reportTelemetry(variables, error);
    },
    onSettled: () => {
      invalidateGetRuleMigrations(migrationId);
      invalidateGetMigrationTranslationStats(migrationId);
    }
  });
};
exports.useInstallMigrationRule = useInstallMigrationRule;