"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.links = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("../../common/constants");
var _translations = require("../app/translations");
var _types = require("../app/types");
var _links = require("../cloud_security_posture/links");
var _console_cloud = require("../common/icons/console_cloud");
var _rollup = require("../common/icons/rollup");
var _dashboards = require("../common/icons/dashboards");
var _links2 = require("../siem_migrations/links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const links = exports.links = {
  id: _types.SecurityPageName.rulesLanding,
  title: _translations.RULES,
  path: _constants.RULES_LANDING_PATH,
  hideTimeline: true,
  skipUrlState: true,
  globalNavPosition: 2,
  capabilities: [[`${_constants.SECURITY_FEATURE_ID}.show`, `${_constants.SECURITY_FEATURE_ID}.detections`]],
  links: [{
    id: _types.SecurityPageName.rules,
    title: _translations.SIEM_RULES,
    description: _i18n.i18n.translate('xpack.securitySolution.appLinks.rulesDescription', {
      defaultMessage: 'Create and manage detection rules for threat detection and monitoring.'
    }),
    landingIcon: _rollup.IconRollup,
    path: _constants.RULES_PATH,
    globalSearchKeywords: [_i18n.i18n.translate('xpack.securitySolution.appLinks.rules', {
      defaultMessage: 'SIEM Rules'
    })],
    links: [{
      id: _types.SecurityPageName.rulesAdd,
      title: _translations.ADD_RULES,
      path: _constants.RULES_ADD_PATH,
      skipUrlState: true,
      hideTimeline: true
    }, {
      id: _types.SecurityPageName.rulesCreate,
      title: _translations.CREATE_NEW_RULE,
      path: _constants.RULES_CREATE_PATH,
      skipUrlState: true,
      hideTimeline: false
    }]
  }, {
    id: _types.SecurityPageName.exceptions,
    title: _translations.EXCEPTIONS,
    description: _i18n.i18n.translate('xpack.securitySolution.appLinks.exceptionsDescription', {
      defaultMessage: 'Create and manage shared exception lists to prevent the creation of unwanted alerts.'
    }),
    landingIcon: _console_cloud.IconConsoleCloud,
    path: _constants.EXCEPTIONS_PATH,
    capabilities: [`${_constants.SECURITY_FEATURE_ID}.showEndpointExceptions`],
    skipUrlState: true,
    hideTimeline: true,
    globalSearchKeywords: [_i18n.i18n.translate('xpack.securitySolution.appLinks.exceptions', {
      defaultMessage: 'Exception lists'
    })]
  }, _links.benchmarksLink, {
    id: _types.SecurityPageName.coverageOverview,
    title: _translations.COVERAGE_OVERVIEW,
    landingIcon: _dashboards.IconDashboards,
    description: _i18n.i18n.translate('xpack.securitySolution.appLinks.coverageOverviewDashboardDescription', {
      defaultMessage: 'Review and maintain your protections MITRE ATT&CK® coverage.'
    }),
    path: _constants.COVERAGE_OVERVIEW_PATH,
    capabilities: [`${_constants.SECURITY_FEATURE_ID}.show`],
    globalSearchKeywords: [_i18n.i18n.translate('xpack.securitySolution.appLinks.coverageOverviewDashboard', {
      defaultMessage: 'MITRE ATT&CK Coverage'
    })]
  }, _links2.siemMigrationsLinks],
  categories: [{
    label: _i18n.i18n.translate('xpack.securitySolution.appLinks.category.management', {
      defaultMessage: 'Management'
    }),
    linkIds: [_types.SecurityPageName.rules, _types.SecurityPageName.cloudSecurityPostureBenchmarks, _types.SecurityPageName.exceptions, _types.SecurityPageName.siemMigrationsRules]
  }, {
    label: _i18n.i18n.translate('xpack.securitySolution.appLinks.category.discover', {
      defaultMessage: 'Discover'
    }),
    linkIds: [_types.SecurityPageName.coverageOverview]
  }]
};