"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OnboardingBanner = void 0;
var _react = _interopRequireWildcard(require("react"));
var _avcBanner = require("@kbn/avc-banner");
var _use_stored_state = require("../hooks/use_stored_state");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OnboardingBanner = exports.OnboardingBanner = /*#__PURE__*/_react.default.memo(() => {
  const [isAVCBannerDismissed, setIsAVCBannerDismissed] = (0, _use_stored_state.useStoredIsAVCBannerDismissed)();
  const isStillYear2025 = (0, _avcBanner.useIsStillYear2025)();
  const dismissAVCBanner = (0, _react.useCallback)(() => {
    setIsAVCBannerDismissed(true);
  }, [setIsAVCBannerDismissed]);
  if (isAVCBannerDismissed || !isStillYear2025) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_avcBanner.AVCResultsBanner, {
    onDismiss: dismissAVCBanner
  });
});
OnboardingBanner.displayName = 'OnboardingBanner';