"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetCustomScripts = void 0;
var _reactQuery = require("@kbn/react-query");
var _constants = require("../../../../common/endpoint/constants");
var _kibana = require("../../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Error type for custom scripts API errors
 */

/**
 * Hook to retrieve custom scripts for a specific agent type
 * @param agentType - The type of agent to get scripts for (e.g., 'crowdstrike')
 * @param options - Additional options for the query
 * @returns Query result containing custom scripts data
 */

const useGetCustomScripts = (agentType, options = {}) => {
  const http = (0, _kibana.useHttp)();
  return (0, _reactQuery.useQuery)({
    queryKey: ['get-custom-scripts', agentType],
    queryFn: () => {
      return http.get(_constants.CUSTOM_SCRIPTS_ROUTE, {
        version: '1',
        query: {
          agentType
        }
      }).then(response => response.data);
    }
  });
};
exports.useGetCustomScripts = useGetCustomScripts;