"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TextValueDisplay = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _classnames = _interopRequireDefault(require("classnames"));
var _empty_value = require("../../../../common/components/empty_value");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Common component for displaying consistent text across the card. Changes here could impact all of
 * display of values on the card
 */
const TextValueDisplay = exports.TextValueDisplay = /*#__PURE__*/(0, _react.memo)(({
  bold,
  truncate,
  size = 's',
  withTooltip = false,
  'data-test-subj': dataTestSubj,
  children
}) => {
  const cssClassNames = (0, _react.useMemo)(() => {
    return (0, _classnames.default)({
      'eui-textTruncate': truncate,
      'eui-textBreakWord': true
    });
  }, [truncate]);
  const textContent = (0, _react.useMemo)(() => {
    return bold ? /*#__PURE__*/_react.default.createElement("strong", null, children) : children;
  }, [bold, children]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    className: cssClassNames,
    size: size,
    "data-test-subj": dataTestSubj
  }, withTooltip && 'string' === typeof children && children.length > 0 && children !== (0, _empty_value.getEmptyValue)() ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    anchorClassName: cssClassNames,
    content: children,
    position: "top"
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, textContent)) : textContent);
});
TextValueDisplay.displayName = 'TextValueDisplay';