"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SuppressedAlerts = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _correlations_details = require("../../left/components/correlations_details");
var _insights_summary_row = require("./insights_summary_row");
var _test_ids = require("./test_ids");
var _utils = require("../../../../../common/detection_engine/utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SUPPRESSED_ALERTS_COUNT_TECHNICAL_PREVIEW = _i18n.i18n.translate('xpack.securitySolution.flyout.right.overview.insights.suppressedAlertsCountTechnicalPreview', {
  defaultMessage: 'Technical Preview'
});
/**
 * Show related alerts by ancestry in summary row
 */
const SuppressedAlerts = ({
  alertSuppressionCount,
  ruleType
}) => {
  const text = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.insights.correlations.suppressedAlertsLabel",
    defaultMessage: "Suppressed {count, plural, one {alert} other {alerts}}",
    values: {
      count: alertSuppressionCount
    }
  }), [alertSuppressionCount]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_insights_summary_row.InsightsSummaryRow, {
    text: text,
    value: alertSuppressionCount,
    expandedSubTab: _correlations_details.CORRELATIONS_TAB_ID,
    "data-test-subj": _test_ids.CORRELATIONS_SUPPRESSED_ALERTS_TEST_ID,
    key: `correlation-row-suppressed-alerts`
  })), ruleType && (0, _utils.isSuppressionRuleInGA)(ruleType) ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    label: SUPPRESSED_ALERTS_COUNT_TECHNICAL_PREVIEW,
    size: "s",
    iconType: "beaker",
    tooltipContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.right.insights.entities.suppressedAlertTechnicalPreviewTooltip",
      defaultMessage: "This functionality is in technical preview and may be changed or removed completely in a future release. Elastic will work to fix any issues, but features in technical preview are not subject to the support SLA of official GA features."
    }),
    tooltipPosition: "bottom",
    "data-test-subj": _test_ids.CORRELATIONS_SUPPRESSED_ALERTS_TECHNICAL_PREVIEW_TEST_ID
  })));
};
exports.SuppressedAlerts = SuppressedAlerts;
SuppressedAlerts.displayName = 'SuppressedAlerts';