"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Assignees = void 0;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_set_alert_assignees = require("../../../../common/components/toolbar/bulk_actions/use_set_alert_assignees");
var _empty_value = require("../../../../common/components/empty_value");
var _constants = require("../../../../common/components/assignees/constants");
var _assignees_apply_panel = require("../../../../common/components/assignees/assignees_apply_panel");
var _use_upselling = require("../../../../common/hooks/use_upselling");
var _use_license = require("../../../../common/hooks/use_license");
var _use_alerts_privileges = require("../../../../detections/containers/detection_engine/alerts/use_alerts_privileges");
var _use_bulk_get_user_profiles = require("../../../../common/components/user_profiles/use_bulk_get_user_profiles");
var _users_avatars_panel = require("../../../../common/components/user_profiles/users_avatars_panel");
var _test_ids = require("./test_ids");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UpdateAssigneesButton = /*#__PURE__*/(0, _react.memo)(({
  togglePopover,
  isDisabled,
  toolTipMessage
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  position: "bottom",
  content: toolTipMessage
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
  "aria-label": "Update assignees",
  "data-test-subj": _test_ids.ASSIGNEES_ADD_BUTTON_TEST_ID,
  iconType: 'plusInCircle',
  onClick: togglePopover,
  isDisabled: isDisabled
})));
UpdateAssigneesButton.displayName = 'UpdateAssigneesButton';
/**
 * Document assignees details displayed in flyout right section header
 */
const Assignees = exports.Assignees = /*#__PURE__*/(0, _react.memo)(({
  eventId,
  assignedUserIds,
  onAssigneesUpdated,
  showAssignees = true
}) => {
  const isPlatinumPlus = (0, _use_license.useLicense)().isPlatinumPlus();
  const upsellingMessage = (0, _use_upselling.useUpsellingMessage)('alert_assignments');
  const {
    hasIndexWrite
  } = (0, _use_alerts_privileges.useAlertsPrivileges)();
  const setAlertAssignees = (0, _use_set_alert_assignees.useSetAlertAssignees)();
  const uids = (0, _react.useMemo)(() => new Set(assignedUserIds), [assignedUserIds]);
  const {
    data: assignedUsers
  } = (0, _use_bulk_get_user_profiles.useBulkGetUserProfiles)({
    uids
  });
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onSuccess = (0, _react.useCallback)(() => {
    if (onAssigneesUpdated) onAssigneesUpdated();
  }, [onAssigneesUpdated]);
  const togglePopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(value => !value);
  }, []);
  const handleApplyAssignees = (0, _react.useCallback)(async assignees => {
    setIsPopoverOpen(false);
    if (setAlertAssignees) {
      await setAlertAssignees(assignees, [eventId], onSuccess, _lodash.noop);
    }
  }, [eventId, onSuccess, setAlertAssignees]);
  const searchInputId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'searchInput'
  });
  const updateAssigneesPopover = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      panelPaddingSize: "none",
      initialFocus: `[id="${searchInputId}"]`,
      button: /*#__PURE__*/_react.default.createElement(UpdateAssigneesButton, {
        togglePopover: togglePopover,
        isDisabled: !hasIndexWrite || !isPlatinumPlus,
        toolTipMessage: upsellingMessage !== null && upsellingMessage !== void 0 ? upsellingMessage : _i18n.i18n.translate('xpack.securitySolution.flyout.right.visualizations.assignees.popoverTooltip', {
          defaultMessage: 'Assign alert'
        })
      }),
      isOpen: isPopoverOpen,
      panelStyle: {
        minWidth: _constants.ASSIGNEES_PANEL_WIDTH
      },
      closePopover: togglePopover
    }, /*#__PURE__*/_react.default.createElement(_assignees_apply_panel.AssigneesApplyPanel, {
      searchInputId: searchInputId,
      assignedUserIds: assignedUserIds,
      onApply: handleApplyAssignees
    }));
  }, [assignedUserIds, handleApplyAssignees, hasIndexWrite, isPlatinumPlus, isPopoverOpen, searchInputId, togglePopover, upsellingMessage]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !showAssignees ? /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": _test_ids.ASSIGNEES_EMPTY_TEST_ID
  }, (0, _empty_value.getEmptyTagValue)()) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    responsive: false,
    "data-test-subj": _test_ids.ASSIGNEES_TEST_ID
  }, assignedUsers && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_users_avatars_panel.UsersAvatarsPanel, {
    userProfiles: assignedUsers,
    maxVisibleAvatars: 2
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, updateAssigneesPopover)));
});
Assignees.displayName = 'Assignees';