"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskDetailsTabBody = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _use_upselling = require("../../../common/hooks/use_upselling");
var _constants = require("../risk_score/constants");
var _enable_risk_score = require("../enable_risk_score");
var _use_selector = require("../../../common/hooks/use_selector");
var _store = require("../../../explore/hosts/store");
var _store2 = require("../../../explore/users/store");
var _risk_information = require("../risk_information");
var i18n = _interopRequireWildcard(require("./translations"));
var _manage_query = require("../../../common/components/page/manage_query");
var _risk_score_over_time = require("../risk_score_over_time");
var _top_risk_score_contributors = require("../top_risk_score_contributors");
var _top_risk_score_contributors_alerts = require("../top_risk_score_contributors_alerts");
var _query_toggle = require("../../../common/containers/query_toggle");
var _search_strategy = require("../../../../common/search_strategy");
var _use_dashboard_href = require("../../../common/hooks/use_dashboard_href");
var _risk_score_no_data_detected = require("../risk_score_onboarding/risk_score_no_data_detected");
var _use_risk_engine_status = require("../../api/hooks/use_risk_engine_status");
var _risk_score_update_panel = require("../risk_score_update_panel");
var _utils = require("../../common/utils");
var _use_risk_score = require("../../api/hooks/use_risk_score");
var _use_missing_risk_engine_privileges = require("../../hooks/use_missing_risk_engine_privileges");
var _risk_engine_privileges_callout = require("../risk_engine_privileges_callout");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledEuiFlexGroup = (0, _styled.default)(_eui.EuiFlexGroup)`
  margin-top: ${({
  theme: {
    euiTheme
  }
}) => euiTheme.size.l};
`;
const getDashboardTitle = riskEntity => riskEntity === _search_strategy.EntityType.host ? _constants.RISKY_HOSTS_DASHBOARD_TITLE : _constants.RISKY_USERS_DASHBOARD_TITLE;
const RiskDetailsTabBodyComponent = ({
  entityName,
  startDate,
  endDate,
  setQuery,
  deleteQuery,
  riskEntity
}) => {
  const queryId = (0, _react.useMemo)(() => riskEntity === _search_strategy.EntityType.host ? _utils.HostRiskScoreQueryId.HOST_DETAILS_RISK_SCORE : _utils.UserRiskScoreQueryId.USER_DETAILS_RISK_SCORE, [riskEntity]);
  const severitySelectionRedux = (0, _use_selector.useDeepEqualSelector)(state => riskEntity === _search_strategy.EntityType.host ? _store.hostsSelectors.hostRiskScoreSeverityFilterSelector()(state, _store.hostsModel.HostsType.details) : _store2.usersSelectors.userRiskScoreSeverityFilterSelector()(state));
  const buttonHref = (0, _use_dashboard_href.useDashboardHref)({
    title: getDashboardTitle(riskEntity)
  });
  const timerange = (0, _react.useMemo)(() => ({
    from: startDate,
    to: endDate
  }), [startDate, endDate]);
  const {
    toggleStatus: overTimeToggleStatus,
    setToggleStatus: setOverTimeToggleStatus
  } = (0, _query_toggle.useQueryToggle)(`${queryId} overTime`);
  const {
    toggleStatus: contributorsToggleStatus,
    setToggleStatus: setContributorsToggleStatus
  } = (0, _query_toggle.useQueryToggle)(`${queryId} contributors`);
  const filterQuery = (0, _react.useMemo)(() => entityName ? (0, _search_strategy.buildEntityNameFilter)(riskEntity, [entityName]) : {}, [entityName, riskEntity]);
  const {
    data,
    loading,
    refetch,
    inspect,
    isDeprecated,
    isModuleEnabled
  } = (0, _use_risk_score.useRiskScore)({
    filterQuery,
    onlyLatest: false,
    riskEntity,
    skip: !overTimeToggleStatus && !contributorsToggleStatus,
    timerange
  });
  const {
    data: riskScoreEngineStatus
  } = (0, _use_risk_engine_status.useRiskEngineStatus)();
  const rules = (0, _react.useMemo)(() => {
    const lastRiskItem = data && data.length > 0 ? data[data.length - 1] : null;
    if (lastRiskItem) {
      return riskEntity === _search_strategy.EntityType.host ? lastRiskItem.host.risk.rule_risks : lastRiskItem.user.risk.rule_risks;
    }
    return [];
  }, [data, riskEntity]);
  (0, _manage_query.useQueryInspector)({
    queryId,
    loading,
    refetch,
    setQuery,
    deleteQuery,
    inspect
  });
  const toggleContributorsQuery = (0, _react.useCallback)(status => {
    setContributorsToggleStatus(status);
  }, [setContributorsToggleStatus]);
  const toggleOverTimeQuery = (0, _react.useCallback)(status => {
    setOverTimeToggleStatus(status);
  }, [setOverTimeToggleStatus]);
  const privileges = (0, _use_missing_risk_engine_privileges.useMissingRiskEnginePrivileges)({
    readonly: true
  });
  const RiskScoreUpsell = (0, _use_upselling.useUpsellingComponent)('entity_analytics_panel');
  if (RiskScoreUpsell) {
    return /*#__PURE__*/_react.default.createElement(RiskScoreUpsell, null);
  }
  if (!privileges.isLoading && !privileges.hasAllRequiredPrivileges) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      hasBorder: true
    }, /*#__PURE__*/_react.default.createElement(_risk_engine_privileges_callout.RiskEnginePrivilegesCallOut, {
      privileges: privileges
    }));
  }
  const status = {
    isDisabled: !isModuleEnabled && !loading,
    isDeprecated: isDeprecated && !loading
  };
  if (status.isDisabled || status.isDeprecated) {
    return /*#__PURE__*/_react.default.createElement(_enable_risk_score.EnableRiskScore, (0, _extends2.default)({}, status, {
      entityType: riskEntity,
      refetch: refetch,
      timerange: timerange
    }));
  }
  if (isModuleEnabled && severitySelectionRedux.length === 0 && data && data.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_risk_score_no_data_detected.RiskScoresNoDataDetected, {
      entityType: riskEntity,
      refetch: refetch
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (riskScoreEngineStatus === null || riskScoreEngineStatus === void 0 ? void 0 : riskScoreEngineStatus.isUpdateAvailable) && /*#__PURE__*/_react.default.createElement(_risk_score_update_panel.RiskScoreUpdatePanel, null), riskScoreEngineStatus !== null && riskScoreEngineStatus !== void 0 && riskScoreEngineStatus.isNewRiskScoreModuleInstalled ? /*#__PURE__*/_react.default.createElement(StyledEuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, (data === null || data === void 0 ? void 0 : data[0]) && /*#__PURE__*/_react.default.createElement(_top_risk_score_contributors_alerts.TopRiskScoreContributorsAlerts, {
    toggleStatus: contributorsToggleStatus,
    toggleQuery: toggleContributorsQuery,
    riskScore: data[0],
    riskEntity: riskEntity,
    loading: loading
  }))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_risk_score_over_time.RiskScoreOverTime, {
    from: startDate,
    queryId: queryId,
    riskEntity: riskEntity,
    title: i18n.RISK_SCORE_OVER_TIME(riskEntity),
    to: endDate,
    toggleQuery: toggleOverTimeQuery,
    toggleStatus: overTimeToggleStatus
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_top_risk_score_contributors.TopRiskScoreContributors, {
    loading: loading,
    queryId: queryId,
    toggleStatus: contributorsToggleStatus,
    toggleQuery: toggleContributorsQuery,
    rules: rules
  }))), /*#__PURE__*/_react.default.createElement(StyledEuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    href: buttonHref,
    isDisabled: !buttonHref,
    "data-test-subj": `risky-${riskEntity}s-view-dashboard-button`,
    target: "_blank",
    iconType: "popout",
    iconSide: "right"
  }, i18n.VIEW_DASHBOARD_BUTTON)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_risk_information.RiskInformationButtonEmpty, {
    riskEntity: riskEntity
  })))));
};
RiskDetailsTabBodyComponent.displayName = 'RiskDetailsTabBodyComponent';
const RiskDetailsTabBody = exports.RiskDetailsTabBody = /*#__PURE__*/_react.default.memo(RiskDetailsTabBodyComponent);
RiskDetailsTabBody.displayName = 'RiskDetailsTabBody';