"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskInputsTab = exports.RISK_INPUTS_TAB_QUERY_ID = exports.EXPAND_ALERT_TEST_ID = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _fp = require("lodash/fp");
var _alert_preview_button = require("../../../../../flyout/shared/components/alert_preview_button");
var _use_global_time = require("../../../../../common/containers/use_global_time");
var _manage_query = require("../../../../../common/components/page/manage_query");
var _common = require("../../../../common");
var _use_risk_contributing_alerts = require("../../../../hooks/use_risk_contributing_alerts");
var _formatted_date = require("../../../../../common/components/formatted_date");
var _use_risk_score = require("../../../../api/hooks/use_risk_score");
var _search_strategy = require("../../../../../../common/search_strategy");
var _asset_criticality = require("../../../asset_criticality");
var _utility_bar = require("../../components/utility_bar");
var _action_column = require("../../components/action_column");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FIRST_RECORD_PAGINATION = {
  cursorStart: 0,
  querySize: 1
};
const EXPAND_ALERT_TEST_ID = exports.EXPAND_ALERT_TEST_ID = 'risk-input-alert-preview-button';
const RISK_INPUTS_TAB_QUERY_ID = exports.RISK_INPUTS_TAB_QUERY_ID = 'RiskInputsTabQuery';
const RiskInputsTab = ({
  entityType,
  entityName,
  scopeId
}) => {
  const {
    setQuery,
    deleteQuery
  } = (0, _use_global_time.useGlobalTime)();
  const [selectedItems, setSelectedItems] = (0, _react.useState)([]);
  const nameFilterQuery = (0, _react.useMemo)(() => {
    return (0, _search_strategy.buildEntityNameFilter)(entityType, [entityName]);
  }, [entityName, entityType]);
  const {
    data: riskScoreData,
    error: riskScoreError,
    loading: loadingRiskScore,
    inspect: inspectRiskScore,
    refetch
  } = (0, _use_risk_score.useRiskScore)({
    riskEntity: entityType,
    filterQuery: nameFilterQuery,
    onlyLatest: false,
    pagination: FIRST_RECORD_PAGINATION,
    skip: nameFilterQuery === undefined
  });
  (0, _manage_query.useQueryInspector)({
    deleteQuery,
    inspect: inspectRiskScore,
    loading: loadingRiskScore,
    queryId: RISK_INPUTS_TAB_QUERY_ID,
    refetch,
    setQuery
  });
  const riskScore = riskScoreData && riskScoreData.length > 0 ? riskScoreData[0] : undefined;
  const alerts = (0, _use_risk_contributing_alerts.useRiskContributingAlerts)({
    riskScore,
    entityType
  });
  const euiTableSelectionProps = (0, _react.useMemo)(() => ({
    initialSelected: [],
    selectable: () => true,
    onSelectionChange: setSelectedItems
  }), []);
  const inputColumns = (0, _react.useMemo)(() => [{
    render: data => /*#__PURE__*/_react.default.createElement(_alert_preview_button.AlertPreviewButton, {
      id: data._id,
      indexName: data.input.index,
      scopeId: scopeId,
      "data-test-subj": EXPAND_ALERT_TEST_ID
    }),
    width: '5%'
  }, {
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.entityDetails.riskInputs.actionsColumn",
      defaultMessage: "Actions"
    }),
    width: '80px',
    render: data => /*#__PURE__*/_react.default.createElement(_action_column.ActionColumn, {
      input: data
    })
  }, {
    field: 'input.timestamp',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.entityDetails.riskInputs.dateColumn",
      defaultMessage: "Date"
    }),
    truncateText: false,
    mobileOptions: {
      show: true
    },
    sortable: true,
    width: '30%',
    render: timestamp => /*#__PURE__*/_react.default.createElement(_formatted_date.PreferenceFormattedDate, {
      value: new Date(timestamp)
    })
  }, {
    field: 'alert',
    'data-test-subj': 'risk-input-table-description-cell',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.entityDetails.riskInputs.riskInputColumn",
      defaultMessage: "Rule name"
    }),
    truncateText: true,
    mobileOptions: {
      show: true
    },
    sortable: true,
    render: alert => (0, _fp.get)(_ruleDataUtils.ALERT_RULE_NAME, alert)
  }, {
    field: 'input.contribution_score',
    'data-test-subj': 'risk-input-table-contribution-cell',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.entityDetails.riskInputs.contributionColumn",
      defaultMessage: "Contribution"
    }),
    truncateText: false,
    mobileOptions: {
      show: true
    },
    sortable: true,
    align: 'right',
    render: formatContribution
  }], [scopeId]);
  if (riskScoreError) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.entityDetails.riskInputs.errorTitle",
        defaultMessage: "Something went wrong"
      }),
      color: "danger",
      iconType: "error"
    }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.entityDetails.riskInputs.errorBody",
      defaultMessage: "Error while fetching risk inputs. Please try again later."
    })));
  }
  const riskInputsAlertSection = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    "data-test-subj": "risk-input-alert-title"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.entityDetails.riskInputs.alertsTitle",
    defaultMessage: "Alerts"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_utility_bar.RiskInputsUtilityBar, {
    riskInputs: selectedItems
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    compressed: true,
    loading: loadingRiskScore || alerts.loading,
    items: alerts.data || [],
    columns: inputColumns,
    sorting: true,
    selection: euiTableSelectionProps,
    itemId: "_id"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(ExtraAlertsMessage, {
    riskScore: riskScore,
    alerts: alerts,
    entityType: entityType
  }));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(ContextsSection, {
    loading: loadingRiskScore,
    riskScore: riskScore,
    entityType: entityType
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), riskInputsAlertSection);
};
exports.RiskInputsTab = RiskInputsTab;
RiskInputsTab.displayName = 'RiskInputsTab';
const ContextsSection = ({
  riskScore,
  loading,
  entityType
}) => {
  const criticality = (0, _react.useMemo)(() => {
    if (!riskScore) {
      return undefined;
    }
    return {
      level: riskScore[entityType].risk.criticality_level,
      contribution: riskScore[entityType].risk.category_2_score
    };
  }, [entityType, riskScore]);
  if (loading || criticality === undefined) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    "data-test-subj": "risk-input-contexts-title"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.entityDetails.riskInputs.contextsTitle",
    defaultMessage: "Contexts"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    compressed: true,
    loading: loading,
    "data-test-subj": "risk-input-contexts-table",
    columns: contextColumns,
    items: [{
      field: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.entityDetails.riskInputs.assetCriticalityField",
        defaultMessage: "Asset Criticality Level"
      }),
      value: /*#__PURE__*/_react.default.createElement(_asset_criticality.AssetCriticalityBadge, {
        criticalityLevel: criticality.level,
        dataTestSubj: "risk-inputs-asset-criticality-badge"
      }),
      contribution: formatContribution(criticality.contribution || 0)
    }]
  }));
};
const contextColumns = [{
  field: 'field',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.entityDetails.riskInputs.fieldColumn",
    defaultMessage: "Field"
  }),
  width: '30%',
  render: field => field
}, {
  field: 'value',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.entityDetails.riskInputs.valueColumn",
    defaultMessage: "Value"
  }),
  width: '30%',
  render: val => val
}, {
  field: 'contribution',
  width: '30%',
  align: 'right',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.entityDetails.riskInputs.contributionColumn",
    defaultMessage: "Contribution"
  }),
  render: score => score
}];
const ExtraAlertsMessage = ({
  riskScore,
  alerts,
  entityType
}) => {
  var _alerts$data, _alerts$data2;
  const totals = !riskScore ? {
    count: 0,
    score: 0
  } : {
    count: riskScore[entityType].risk.category_1_count,
    score: riskScore[entityType].risk.category_1_score
  };
  const displayed = {
    count: ((_alerts$data = alerts.data) === null || _alerts$data === void 0 ? void 0 : _alerts$data.length) || 0,
    score: ((_alerts$data2 = alerts.data) === null || _alerts$data2 === void 0 ? void 0 : _alerts$data2.reduce((sum, {
      input
    }) => sum + (input.contribution_score || 0), 0)) || 0
  };
  if (displayed.count >= totals.count) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "risk-input-extra-alerts-message",
    size: "s",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.entityDetails.riskInputs.extraAlertsMessage",
      defaultMessage: "{count} more alerts contributed {score} to the calculated risk score",
      values: {
        count: totals.count - displayed.count,
        score: formatContribution(totals.score - displayed.score)
      }
    }),
    iconType: "annotation"
  });
};
const formatContribution = value => {
  const fixedValue = (0, _common.formatRiskScore)(value);

  // prevent +0.00 for values like 0.0001
  if (fixedValue === '0.00') {
    return fixedValue;
  }
  if (value > 0) {
    return `+${fixedValue}`;
  }
  return fixedValue;
};