"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TagsFilterPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("../../../../common/translations"));
var _toggle_selected_group = require("../../../../../common/components/ml_popover/jobs_table/filters/toggle_selected_group");
var _helpers = require("../helpers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TAGS_POPOVER_WIDTH = 500;
/**
 * Popover for selecting tags to filter on
 *
 * @param tags to display for filtering
 * @param onSelectedTagsChanged change listener to be notified when tag selection changes
 */
const TagsFilterPopoverComponent = ({
  tags,
  selectedTags,
  onSelectedTagsChanged
}) => {
  const sortedTags = (0, _react.useMemo)(() => (0, _helpers.caseInsensitiveSort)(Array.from(new Set([...tags, ...selectedTags]))), [selectedTags, tags]);
  const [isTagPopoverOpen, setIsTagPopoverOpen] = (0, _react.useState)(false);
  const [selectableOptions, setSelectableOptions] = (0, _react.useState)(() => {
    const selectedTagsSet = new Set(selectedTags);
    return sortedTags.map(label => ({
      label,
      checked: selectedTagsSet.has(label) ? 'on' : undefined
    }));
  });
  const handleSelectableOptionsChange = (newOptions, _, changedOption) => {
    setSelectableOptions(newOptions);
    (0, _toggle_selected_group.toggleSelectedGroup)(changedOption.label, selectedTags, onSelectedTagsChanged);
  };
  (0, _react.useEffect)(() => {
    const selectedTagsSet = new Set(selectedTags);
    const newSelectableOptions = sortedTags.map(label => ({
      label,
      checked: selectedTagsSet.has(label) ? 'on' : undefined
    }));
    setSelectableOptions(newSelectableOptions);
  }, [sortedTags, selectedTags]);
  const triggerButton = /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    grow: true,
    iconType: "arrowDown",
    onClick: () => setIsTagPopoverOpen(!isTagPopoverOpen),
    numFilters: tags.length,
    isSelected: isTagPopoverOpen,
    hasActiveFilters: selectedTags.length > 0,
    numActiveFilters: selectedTags.length,
    "data-test-subj": "tags-filter-popover-button"
  }, i18n.TAGS);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    ownFocus: true,
    button: triggerButton,
    isOpen: isTagPopoverOpen,
    closePopover: () => setIsTagPopoverOpen(!isTagPopoverOpen),
    panelPaddingSize: "none",
    repositionOnScroll: true,
    panelProps: {
      'data-test-subj': 'tags-filter-popover'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    searchable: true,
    searchProps: {
      placeholder: i18n.SEARCH_TAGS
    },
    "aria-label": i18n.RULES_TAG_SEARCH,
    options: selectableOptions,
    onChange: handleSelectableOptionsChange,
    emptyMessage: i18n.NO_TAGS_AVAILABLE,
    noMatchesMessage: i18n.NO_TAGS_AVAILABLE
  }, (list, search) => /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: TAGS_POPOVER_WIDTH
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, search), list)));
};
TagsFilterPopoverComponent.displayName = 'TagsFilterPopoverComponent';
const TagsFilterPopover = exports.TagsFilterPopover = /*#__PURE__*/_react.default.memo(TagsFilterPopoverComponent);
TagsFilterPopover.displayName = 'TagsFilterPopover';