"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldUpgrade = FieldUpgrade;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _split_accordion = require("../../../../../../common/components/split_accordion");
var _field_comparison_side = require("../comparison_side/field_comparison_side");
var _field_final_side = require("../field_final_side");
var _field_upgrade_header = require("./field_upgrade_header");
var _field_upgrade_context = require("./field_upgrade_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FieldUpgrade() {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    fieldName,
    fieldUpgradeState,
    hasConflict,
    isCustomized
  } = (0, _field_upgrade_context.useFieldUpgradeContext)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_split_accordion.SplitAccordion, {
    header: /*#__PURE__*/_react.default.createElement(_field_upgrade_header.FieldUpgradeHeader, {
      fieldName: fieldName,
      fieldUpgradeState: fieldUpgradeState,
      isCustomized: isCustomized
    }),
    initialIsOpen: hasConflict,
    "data-test-subj": `${(0, _lodash.snakeCase)(fieldName)}-upgrade`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_field_comparison_side.FieldComparisonSide, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0,
    css: (0, _css.css)`
              align-self: stretch;
              border-right: ${euiTheme.border.thin};
            `
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_field_final_side.FieldFinalSide, null)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }));
}