"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExceptionsViewerUtility = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18nReact = require("@kbn/i18n-react");
var _utility_bar = require("../../../../common/components/utility_bar");
var _formatted_date = require("../../../../common/components/formatted_date");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledText = _styledComponents.default.span`
  font-weight: bold;
`;
const MyUtilities = _styledComponents.default.div`
  height: 50px;
`;
const StyledBarGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  align-items: center;
`;
const PaginationUtilityBarText = (0, _styledComponents.default)(_utility_bar.UtilityBarText)`
  align-self: center;
`;
/**
 * Utilities include exception item counts and group by options
 */
const ExceptionsViewerUtilityComponent = ({
  pagination,
  lastUpdated,
  exceptionsToShow,
  onChangeExceptionsToShow,
  isEndpoint
}) => {
  return /*#__PURE__*/_react.default.createElement(MyUtilities, null, /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBar, null, /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarSection, null, /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarGroup, null, /*#__PURE__*/_react.default.createElement(PaginationUtilityBarText, {
    dataTestSubj: "exceptionsShowing"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.exceptions.viewer.paginationDetails",
    defaultMessage: "Showing {partOne} of {partTwo}",
    values: {
      partOne: /*#__PURE__*/_react.default.createElement(StyledText, null, `${pagination.totalItemCount === 0 ? '0' : '1'}-${Math.min(pagination.pageSize, pagination.totalItemCount)}`),
      partTwo: /*#__PURE__*/_react.default.createElement(StyledText, null, `${pagination.totalItemCount}`)
    }
  })))), /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarSection, null, /*#__PURE__*/_react.default.createElement(StyledBarGroup, null, /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarText, {
    dataTestSubj: "lastUpdated"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": "exceptionsViewerLastUpdated"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.exceptions.viewer.lastUpdated",
    defaultMessage: "Updated {updated}",
    values: {
      updated: /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
        value: lastUpdated
      })
    }
  }))), !isEndpoint && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: "Displayed exceptions button group",
    options: [{
      id: `active`,
      label: i18n.ACTIVE_EXCEPTIONS
    }, {
      id: `expired`,
      label: i18n.EXPIRED_EXCEPTIONS
    }],
    idToSelectedMap: exceptionsToShow,
    onChange: onChangeExceptionsToShow,
    type: "multi"
  })))));
};
ExceptionsViewerUtilityComponent.displayName = 'ExceptionsViewerUtilityComponent';
const ExceptionsViewerUtility = exports.ExceptionsViewerUtility = /*#__PURE__*/_react.default.memo(ExceptionsViewerUtilityComponent);
ExceptionsViewerUtility.displayName = 'ExceptionsViewerUtility';