"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRouteEntriesFromPolicyConfig = exports.getPolicyConfigValueFromRouteEntries = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getRouteEntriesFromPolicyConfig = policyConfig => {
  var _policyConfig$route_e;
  if (policyConfig === undefined) {
    return [];
  }
  const entriesString = (_policyConfig$route_e = policyConfig.route_entries) === null || _policyConfig$route_e === void 0 ? void 0 : _policyConfig$route_e.value;
  if (entriesString && entriesString.length > 0) {
    const entries = JSON.parse(entriesString);
    return entries;
  }
  return [];
};
exports.getRouteEntriesFromPolicyConfig = getRouteEntriesFromPolicyConfig;
const getPolicyConfigValueFromRouteEntries = routeEntries => {
  // skip empty config rows
  const nonEmptyEntries = routeEntries.filter(entry => entry.dataId && entry.datastream);
  return JSON.stringify(nonEmptyEntries);
};
exports.getPolicyConfigValueFromRouteEntries = getPolicyConfigValueFromRouteEntries;