"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAssistantBaseKibanaFeature = void 0;
var _i18n = require("@kbn/i18n");
var _coreApplicationCommon = require("@kbn/core-application-common");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAssistantBaseKibanaFeature = () => ({
  id: _constants.ASSISTANT_FEATURE_ID,
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.linkSecuritySolutionAssistantTitle', {
    defaultMessage: 'Elastic AI Assistant'
  }),
  order: 1300,
  category: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.security,
  app: [_constants.ASSISTANT_FEATURE_ID, 'kibana'],
  catalogue: [_constants.APP_ID],
  minimumLicense: 'enterprise',
  management: {
    kibana: ['securityAiAssistantManagement']
  },
  privileges: {
    all: {
      api: ['elasticAssistant'],
      app: [_constants.ASSISTANT_FEATURE_ID, 'kibana'],
      catalogue: [_constants.APP_ID],
      savedObject: {
        all: [],
        read: []
      },
      ui: [],
      management: {
        kibana: ['securityAiAssistantManagement']
      }
    },
    read: {
      // No read-only mode currently supported
      disabled: true,
      savedObject: {
        all: [],
        read: []
      },
      ui: []
    }
  }
});
exports.getAssistantBaseKibanaFeature = getAssistantBaseKibanaFeature;