"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecurityNavControlService = exports.Providers = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _rxjs = require("rxjs");
var _public = require("@kbn/kibana-react-plugin/public");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _nav_control_component = require("./nav_control_component");
var _components = require("../components");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SecurityNavControlService {
  constructor(buildFlavor) {
    (0, _defineProperty2.default)(this, "securityLicense", void 0);
    (0, _defineProperty2.default)(this, "logoutUrl", void 0);
    (0, _defineProperty2.default)(this, "securityApiClients", void 0);
    (0, _defineProperty2.default)(this, "navControlRegistered", void 0);
    (0, _defineProperty2.default)(this, "securityFeaturesSubscription", void 0);
    (0, _defineProperty2.default)(this, "stop$", new _rxjs.ReplaySubject(1));
    (0, _defineProperty2.default)(this, "userMenuLinks$", new _rxjs.BehaviorSubject([]));
    this.buildFlavor = buildFlavor;
  }
  setup({
    securityLicense,
    logoutUrl,
    securityApiClients
  }) {
    this.securityLicense = securityLicense;
    this.logoutUrl = logoutUrl;
    this.securityApiClients = securityApiClients;
  }
  start({
    core,
    authc
  }) {
    this.securityFeaturesSubscription = this.securityLicense.features$.subscribe(({
      showLinks
    }) => {
      const isAnonymousPath = core.http.anonymousPaths.isAnonymous(window.location.pathname);
      const shouldRegisterNavControl = !isAnonymousPath && showLinks && !this.navControlRegistered;
      if (shouldRegisterNavControl) {
        this.registerSecurityNavControl(core, authc);
      }
    });
    return {
      getUserMenuLinks$: () => this.userMenuLinks$.pipe((0, _rxjs.map)(this.sortUserMenuLinks), (0, _rxjs.takeUntil)(this.stop$)),
      addUserMenuLinks: userMenuLinks => {
        const currentLinks = this.userMenuLinks$.value;
        const hasCustomProfileLink = currentLinks.find(({
          setAsProfile
        }) => setAsProfile === true);
        const passedCustomProfileLinkCount = userMenuLinks.filter(({
          setAsProfile
        }) => setAsProfile === true).length;
        if (hasCustomProfileLink && passedCustomProfileLinkCount > 0) {
          throw new Error(`Only one custom profile link can be set. A custom profile link named ${hasCustomProfileLink.label} (${hasCustomProfileLink.href}) already exists`);
        }
        if (passedCustomProfileLinkCount > 1) {
          throw new Error(`Only one custom profile link can be passed at a time (found ${passedCustomProfileLinkCount})`);
        }
        const newLinks = [...currentLinks, ...userMenuLinks];
        this.userMenuLinks$.next(newLinks);
      }
    };
  }
  stop() {
    if (this.securityFeaturesSubscription) {
      this.securityFeaturesSubscription.unsubscribe();
      this.securityFeaturesSubscription = undefined;
    }
    this.navControlRegistered = false;
    this.stop$.next();
  }
  registerSecurityNavControl(core, authc) {
    core.chrome.navControls.registerRight({
      order: 4000,
      mount: element => {
        _reactDom.default.render(core.rendering.addContext(/*#__PURE__*/_react.default.createElement(Providers, {
          services: core,
          authc: authc,
          securityApiClients: this.securityApiClients
        }, /*#__PURE__*/_react.default.createElement(_nav_control_component.SecurityNavControl, {
          editProfileUrl: core.http.basePath.prepend('/security/account'),
          logoutUrl: this.logoutUrl,
          userMenuLinks$: this.userMenuLinks$,
          buildFlavour: this.buildFlavor
        }))), element);
        return () => _reactDom.default.unmountComponentAtNode(element);
      }
    });
    this.navControlRegistered = true;
  }
  sortUserMenuLinks(userMenuLinks) {
    return (0, _lodash.sortBy)(userMenuLinks, 'order');
  }
}
exports.SecurityNavControlService = SecurityNavControlService;
const Providers = ({
  authc,
  services,
  securityApiClients,
  children
}) => /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
  services: services
}, /*#__PURE__*/_react.default.createElement(_components.AuthenticationProvider, {
  authc: authc
}, /*#__PURE__*/_react.default.createElement(_components.SecurityApiClientsProvider, securityApiClients, /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
  coreStart: services
}, children))));
exports.Providers = Providers;