"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AuthenticationStatePage = void 0;
require("./authentication_state_page.scss");
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AuthenticationStatePage = props => /*#__PURE__*/_react.default.createElement("div", {
  className: `secAuthenticationStatePage ${props.className || ''}`
}, /*#__PURE__*/_react.default.createElement("header", {
  className: "secAuthenticationStatePage__header"
}, /*#__PURE__*/_react.default.createElement("div", {
  className: "secAuthenticationStatePage__content eui-textCenter"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "xxl"
}), /*#__PURE__*/_react.default.createElement("span", {
  className: "secAuthenticationStatePage__logo"
}, props.logo ? /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
  src: props.logo,
  size: 40,
  alt: 'logo'
}) : /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
  type: "logoElastic",
  size: "xxl"
})), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "l",
  className: "secAuthenticationStatePage__title"
}, /*#__PURE__*/_react.default.createElement("h1", null, props.title)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "xl"
}))), /*#__PURE__*/_react.default.createElement("div", {
  className: "secAuthenticationStatePage__content eui-textCenter"
}, props.children));
exports.AuthenticationStatePage = AuthenticationStatePage;