"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIndexMapping = void 0;
var _reactQuery = require("@kbn/react-query");
var _use_kibana = require("../use_kibana");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const POLLING_INTERVAL = 15 * 1000;
const useIndexMapping = indexName => {
  const {
    http
  } = (0, _use_kibana.useKibana)().services;
  const queryKey = [_constants.QueryKeys.FetchMapping, indexName];
  const result = (0, _reactQuery.useQuery)({
    queryKey,
    refetchInterval: POLLING_INTERVAL,
    refetchIntervalInBackground: true,
    refetchOnWindowFocus: 'always',
    queryFn: () => http.fetch(`/api/index_management/mapping/${encodeURIComponent(indexName)}`)
  });
  return {
    queryKey,
    ...result
  };
};
exports.useIndexMapping = useIndexMapping;