"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteIndexModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_delete_index = require("../../hooks/api/use_delete_index");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DeleteIndexModal = ({
  onCancel,
  indexName,
  navigateToIndexListPage
}) => {
  const {
    mutate,
    isLoading,
    isSuccess
  } = (0, _use_delete_index.useDeleteIndex)(indexName);
  (0, _react.useEffect)(() => {
    if (isSuccess) {
      navigateToIndexListPage();
    }
  }, [navigateToIndexListPage, isSuccess]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "data-test-subj": "deleteIndexActionModal",
    title: _i18n.i18n.translate('xpack.searchIndices.indexActionsMenu.deleteIndex.confirmModal.modalTitle', {
      defaultMessage: 'Delete index'
    }),
    onCancel: onCancel,
    onConfirm: () => mutate(),
    isLoading: isLoading,
    buttonColor: "danger",
    confirmButtonDisabled: false,
    cancelButtonText: _i18n.i18n.translate('xpack.searchIndices.indexActionsMenu.deleteIndex.confirmModal.cancelButtonText', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.searchIndices.indexActionsMenu.deleteIndex.confirmModal.confirmButtonText', {
      defaultMessage: 'Delete index'
    })
  }, /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchIndices.indexActionsMenu.deleteIndex.deleteDescription",
    defaultMessage: "You are about to delete this index:"
  })), /*#__PURE__*/_react.default.createElement("ul", null, /*#__PURE__*/_react.default.createElement("li", null, indexName)), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchIndices.indexActionsMenu.deleteIndex.deleteWarningDescription",
    defaultMessage: "You can't recover a deleted index. Make sure you have appropriate backups."
  }))));
};
exports.DeleteIndexModal = DeleteIndexModal;