"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createFetchFlamechart = createFetchFlamechart;
var _common = require("@kbn/observability-plugin/common");
var _percent_to_factor = require("../../utils/percent_to_factor");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const targetSampleSize = 20000; // minimum number of samples to get statistically sound results

function createFetchFlamechart({
  createProfilingEsClient
}) {
  return async ({
    core,
    esClient,
    indices,
    stacktraceIdsField,
    query,
    totalSeconds
  }) => {
    const [co2PerKWH, datacenterPUE, pervCPUWattX86, pervCPUWattArm64, awsCostDiscountRate, costPervCPUPerHour, azureCostDiscountRate] = await Promise.all([core.uiSettings.client.get(_common.profilingCo2PerKWH), core.uiSettings.client.get(_common.profilingDatacenterPUE), core.uiSettings.client.get(_common.profilingPervCPUWattX86), core.uiSettings.client.get(_common.profilingPervCPUWattArm64), core.uiSettings.client.get(_common.profilingAWSCostDiscountRate), core.uiSettings.client.get(_common.profilingCostPervCPUPerHour), core.uiSettings.client.get(_common.profilingAzureCostDiscountRate)]);
    const profilingEsClient = createProfilingEsClient({
      esClient
    });
    const flamegraph = await profilingEsClient.profilingFlamegraph({
      query,
      sampleSize: targetSampleSize,
      durationSeconds: totalSeconds,
      co2PerKWH,
      datacenterPUE,
      pervCPUWattX86,
      pervCPUWattArm64,
      awsCostDiscountRate: (0, _percent_to_factor.percentToFactor)(awsCostDiscountRate),
      costPervCPUPerHour,
      azureCostDiscountRate: (0, _percent_to_factor.percentToFactor)(azureCostDiscountRate),
      indices,
      stacktraceIdsField
    });
    return {
      ...flamegraph,
      TotalSeconds: totalSeconds
    };
  };
}