"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PromptTelemetry = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _event_definitions = require("./event_definitions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class PromptTelemetry {
  constructor() {
    (0, _defineProperty2.default)(this, "reportEvent", void 0);
  }
  setup({
    analytics
  }) {
    _event_definitions.eventTypes.forEach(eventType => {
      analytics.registerEventType(eventType);
    });
    return {};
  }
  start({
    analytics
  }) {
    this.reportEvent = analytics.reportEvent;
    return {
      reportInterceptInteractionTermination: this.reportInterceptTermination.bind(this),
      reportInterceptInteractionProgress: this.reportInterceptInteractionProgress.bind(this),
      reportTriggerFetchError: this.reportTriggerFetchError.bind(this)
    };
  }
  reportInterceptTermination({
    interactionType,
    interceptRunId
  }) {
    var _this$reportEvent;
    (_this$reportEvent = this.reportEvent) === null || _this$reportEvent === void 0 ? void 0 : _this$reportEvent.call(this, _event_definitions.EventMetric.PRODUCT_INTERCEPT_TERMINATION_INTERACTION, {
      [_event_definitions.EventFieldType.INTERACTION_TYPE]: interactionType,
      [_event_definitions.EventFieldType.INTERCEPT_RUN_ID]: String(interceptRunId)
    });
  }
  reportInterceptInteractionProgress({
    interceptRunId,
    metricId,
    value
  }) {
    var _this$reportEvent2;
    (_this$reportEvent2 = this.reportEvent) === null || _this$reportEvent2 === void 0 ? void 0 : _this$reportEvent2.call(this, _event_definitions.EventMetric.PRODUCT_INTERCEPT_PROGRESS_INTERACTION, {
      [_event_definitions.EventFieldType.INTERACTION_METRIC]: metricId,
      [_event_definitions.EventFieldType.INTERACTION_METRIC_VALUE]: value,
      [_event_definitions.EventFieldType.INTERCEPT_RUN_ID]: String(interceptRunId)
    });
  }
  reportTriggerFetchError({
    errorMessage
  }) {
    var _this$reportEvent3;
    (_this$reportEvent3 = this.reportEvent) === null || _this$reportEvent3 === void 0 ? void 0 : _this$reportEvent3.call(this, _event_definitions.EventMetric.PRODUCT_INTERCEPT_TRIGGER_FETCH_ERROR, {
      [_event_definitions.EventFieldType.TRIGGER_FETCH_ERROR_MESSAGE]: errorMessage
    });
  }
}
exports.PromptTelemetry = PromptTelemetry;