"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createActionService = void 0;
var _validate_license = require("./validate_license");
var _create_action_handler = require("./create_action_handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createActionService = osqueryContext => {
  let licenseSubscription = null;
  const licenses = {
    isActivePlatinumLicense: false
  };
  licenseSubscription = osqueryContext.licensing.license$.subscribe(license => {
    licenses.isActivePlatinumLicense = license.isActive && license.hasAtLeast('platinum');
  });
  const create = async (params, alertData) => {
    const error = (0, _validate_license.validateLicense)(licenses);
    return (0, _create_action_handler.createActionHandler)(osqueryContext, params, {
      alertData,
      error
    });
  };
  const stop = () => {
    if (licenseSubscription) {
      licenseSubscription.unsubscribe();
    }
  };
  return {
    create,
    stop
  };
};
exports.createActionService = createActionService;