"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRelatedColumns = exports.RELATION_COL = exports.RELATED_ALERT_REASON = exports.RELATED_ACTIONS_COL = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RELATED_ALERT_REASON = exports.RELATED_ALERT_REASON = 'relatedAlertReason';
const RELATION_COL = exports.RELATION_COL = 'relatedRelation';
const RELATED_ACTIONS_COL = exports.RELATED_ACTIONS_COL = 'relatedActions';
const getRelatedColumns = () => {
  return [{
    id: _ruleDataUtils.ALERT_STATUS,
    displayAsText: _i18n.i18n.translate('xpack.observability.alertsTGrid.statusColumnDescription', {
      defaultMessage: 'Alert Status'
    }),
    initialWidth: 120,
    isSortable: false,
    actions: false
  }, {
    id: _ruleDataUtils.ALERT_RULE_NAME,
    displayAsText: _i18n.i18n.translate('xpack.observability.alertsTGrid.ruleNameColumnDescription', {
      defaultMessage: 'Rule name'
    }),
    initialWidth: 250,
    isSortable: false,
    actions: false
  }, {
    id: RELATED_ALERT_REASON,
    displayAsText: _i18n.i18n.translate('xpack.observability.alertsTGrid.reasonDescription', {
      defaultMessage: 'Reason'
    }),
    initialWidth: 400,
    isSortable: false,
    actions: false
  }, {
    id: RELATION_COL,
    displayAsText: _i18n.i18n.translate('xpack.observability.alertsTGrid.relationColumnDescription', {
      defaultMessage: 'Relation'
    }),
    initialWidth: 350,
    isSortable: false,
    actions: false
  }, {
    id: _ruleDataUtils.ALERT_CASE_IDS,
    displayAsText: _i18n.i18n.translate('xpack.observability.alertsTGrid.caseIdsColumnDescription', {
      defaultMessage: 'Attached cases'
    }),
    initialWidth: 150,
    isSortable: false,
    actions: false
  }, {
    id: RELATED_ACTIONS_COL,
    displayAsText: _i18n.i18n.translate('xpack.observability.alertsTGrid.actionsColumnDescription', {
      defaultMessage: 'Actions'
    }),
    initialWidth: 75,
    isResizable: false,
    isSortable: false,
    actions: false
  }];
};
exports.getRelatedColumns = getRelatedColumns;