"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Footer = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("@kbn/home-sample-data-tab/src/constants");
var _public = require("@kbn/kibana-react-plugin/public");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _support_icon = _interopRequireDefault(require("./support_icon.svg"));
var _demo_icon = _interopRequireDefault(require("./demo_icon.svg"));
var _docs_icon = _interopRequireDefault(require("./docs_icon.svg"));
var _forum_icon = _interopRequireDefault(require("./forum_icon.svg"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const URL_FORUM = 'https://discuss.elastic.co/';
const Footer = () => {
  const {
    services: {
      docLinks,
      chrome
    }
  } = (0, _public.useKibana)();
  const helpSupportUrl = (0, _useObservable.default)(chrome.getHelpSupportUrl$());
  const sections = [{
    iconUrl: _demo_icon.default,
    title: _i18n.i18n.translate('xpack.observability_onboarding.experimentalOnboardingFlow.demoEnvironmentFlexItemLabel', {
      defaultMessage: 'Demo environment'
    }),
    description: _i18n.i18n.translate('xpack.observability_onboarding.experimentalOnboardingFlow.demoEnvironmentFlexItemDescription', {
      defaultMessage: 'Explore our live demo environment'
    }),
    linkLabel: _i18n.i18n.translate('xpack.observability_onboarding.experimentalOnboardingFlow.demoEnvironmentFlexItemLinkLabel', {
      defaultMessage: 'Explore demo'
    }),
    link: _constants.URL_DEMO_ENV,
    testSubject: 'observabilityOnboardingFooterExploreDemoLink'
  }, {
    iconUrl: _forum_icon.default,
    title: _i18n.i18n.translate('xpack.observability_onboarding.experimentalOnboardingFlow.exploreForumFlexItemLabel', {
      defaultMessage: 'Explore forum'
    }),
    description: _i18n.i18n.translate('xpack.observability_onboarding.experimentalOnboardingFlow.exploreForumFlexItemDescription', {
      defaultMessage: 'Exchange thoughts about Elastic'
    }),
    linkLabel: _i18n.i18n.translate('xpack.observability_onboarding.experimentalOnboardingFlow.exploreForumFlexItemLinkLabel', {
      defaultMessage: 'Discuss forum'
    }),
    linkARIALabel: _i18n.i18n.translate('xpack.observability_onboarding.experimentalOnboardingFlow.exploreForumFlexItemLinkARIALabel', {
      defaultMessage: 'Discuss forum. Open Elastic forum'
    }),
    link: URL_FORUM,
    testSubject: 'observabilityOnboardingFooterDiscussForumLink'
  }, {
    iconUrl: _docs_icon.default,
    title: _i18n.i18n.translate('xpack.observability_onboarding.experimentalOnboardingFlow.browseDocumentationFlexItemLabel', {
      defaultMessage: 'Browse documentation'
    }),
    description: _i18n.i18n.translate('xpack.observability_onboarding.experimentalOnboardingFlow.browseDocumentationFlexItemDescription', {
      defaultMessage: 'In-depth guides on all Elastic features'
    }),
    linkLabel: _i18n.i18n.translate('xpack.observability_onboarding.experimentalOnboardingFlow.browseDocumentationFlexItemLinkLabel', {
      defaultMessage: 'Learn more'
    }),
    linkARIALabel: _i18n.i18n.translate('xpack.observability_onboarding.experimentalOnboardingFlow.browseDocumentationFlexItemLinkARIALabel', {
      defaultMessage: 'Learn more about all Elastic features'
    }),
    link: docLinks.links.observability.guide,
    testSubject: 'observabilityOnboardingFooterLearnMoreLink'
  }, {
    iconUrl: _support_icon.default,
    title: _i18n.i18n.translate('xpack.observability_onboarding.experimentalOnboardingFlow.supportHubFlexItemLabel', {
      defaultMessage: 'Support Hub'
    }),
    description: _i18n.i18n.translate('xpack.observability_onboarding.experimentalOnboardingFlow.supportHubFlexItemDescription', {
      defaultMessage: 'Get help by opening a case'
    }),
    linkLabel: _i18n.i18n.translate('xpack.observability_onboarding.experimentalOnboardingFlow.supportHubFlexItemLinkLabel', {
      defaultMessage: 'Open Support Hub'
    }),
    link: helpSupportUrl,
    testSubject: 'observabilityOnboardingFooterOpenSupportHubLink'
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xl",
    justifyContent: "center",
    alignItems: "center"
  }, sections.map((section, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: index,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
    size: "l",
    name: "",
    imageUrl: section.iconUrl,
    color: "subdued"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("strong", null, section.title)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("p", null, section.description)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": section.testSubject,
    "aria-label": section.linkARIALabel,
    href: section.link,
    target: "_blank",
    external: true
  }, section.linkLabel)))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }));
};
exports.Footer = Footer;