"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatDataFrameAnalyticsCreateJobUrl = formatDataFrameAnalyticsCreateJobUrl;
exports.formatDataFrameAnalyticsExplorationUrl = formatDataFrameAnalyticsExplorationUrl;
exports.formatDataFrameAnalyticsJobManagementUrl = formatDataFrameAnalyticsJobManagementUrl;
exports.formatDataFrameAnalyticsMapUrl = formatDataFrameAnalyticsMapUrl;
var _lodash = require("lodash");
var _public = require("@kbn/kibana-utils-plugin/public");
var _common = require("./common");
var _locator = require("../../../common/constants/locator");
var _string_utils = require("../../../common/util/string_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Creates URL to the DataFrameAnalytics page
 */

function formatDataFrameAnalyticsJobManagementUrl(appBasePath, mlUrlGeneratorState) {
  let url = `${appBasePath}/${_locator.ML_PAGES.DATA_FRAME_ANALYTICS_JOBS_MANAGE}`;
  if (mlUrlGeneratorState) {
    const {
      jobId,
      groupIds,
      globalState
    } = mlUrlGeneratorState;
    if (jobId || groupIds) {
      const queryTextArr = [];
      if (jobId) {
        queryTextArr.push((0, _string_utils.getJobQueryText)(jobId));
      }
      if (groupIds) {
        queryTextArr.push((0, _string_utils.getGroupQueryText)(groupIds));
      }
      const jobsListState = {
        ...(queryTextArr.length > 0 ? {
          queryText: queryTextArr.join(' ')
        } : {})
      };
      const queryState = {
        [_locator.ML_PAGES.DATA_FRAME_ANALYTICS_JOBS_MANAGE]: jobsListState
      };
      url = (0, _public.setStateToKbnUrl)('_a', queryState, {
        useHash: false,
        storeInHashQuery: false
      }, url);
    }
    if (globalState) {
      url = (0, _public.setStateToKbnUrl)('_g', globalState, {
        useHash: false,
        storeInHashQuery: false
      }, url);
    }
  }
  return url;
}

/**
 * Creates URL to the DataFrameAnalytics Exploration page
 */
function formatDataFrameAnalyticsExplorationUrl(appBasePath, mlUrlGeneratorState) {
  let url = `${appBasePath}/${_locator.ML_PAGES.DATA_FRAME_ANALYTICS_EXPLORATION}`;
  if (mlUrlGeneratorState) {
    const {
      jobId,
      analysisType,
      queryText,
      globalState
    } = mlUrlGeneratorState;
    const queryState = {
      ml: {
        jobId,
        analysisType
      },
      ...globalState
    };
    const appState = {
      [_locator.ML_PAGES.DATA_FRAME_ANALYTICS_EXPLORATION]: {
        ...(queryText ? {
          queryText
        } : {})
      }
    };
    if (!(0, _lodash.isEmpty)(appState[_locator.ML_PAGES.DATA_FRAME_ANALYTICS_EXPLORATION])) {
      url = (0, _public.setStateToKbnUrl)('_a', appState, {
        useHash: false,
        storeInHashQuery: false
      }, url);
    }
    url = (0, _public.setStateToKbnUrl)('_g', queryState, {
      useHash: false,
      storeInHashQuery: false
    }, url);
  }
  return url;
}

/**
 * Creates URL to the DataFrameAnalytics creation wizard
 */
function formatDataFrameAnalyticsCreateJobUrl(appBasePath, pageState) {
  return (0, _common.formatGenericMlUrl)(appBasePath, _locator.ML_PAGES.DATA_FRAME_ANALYTICS_CREATE_JOB, pageState);
}

/**
 * Creates URL to the DataFrameAnalytics Map page
 */
function formatDataFrameAnalyticsMapUrl(appBasePath, mlUrlGeneratorState) {
  let url = `${appBasePath}/${_locator.ML_PAGES.DATA_FRAME_ANALYTICS_MAP}`;
  if (mlUrlGeneratorState) {
    const {
      jobId,
      modelId,
      analysisType,
      globalState,
      queryText
    } = mlUrlGeneratorState;
    const queryState = {
      ml: {
        jobId,
        modelId,
        analysisType
      },
      ...globalState
    };
    const appState = {
      [_locator.ML_PAGES.DATA_FRAME_ANALYTICS_MAP]: {
        ...(queryText ? {
          queryText
        } : {})
      }
    };
    if (!(0, _lodash.isEmpty)(appState[_locator.ML_PAGES.DATA_FRAME_ANALYTICS_MAP])) {
      url = (0, _public.setStateToKbnUrl)('_a', appState, {
        useHash: false,
        storeInHashQuery: false
      }, url);
    }
    url = (0, _public.setStateToKbnUrl)('_g', queryState, {
      useHash: false,
      storeInHashQuery: false
    }, url);
  }
  return url;
}