"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Layer = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _compatible_layer = require("./compatible_layer");
var _incompatible_layer = require("./incompatible_layer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Layer = ({
  layer,
  layerIndex,
  embeddable
}) => {
  var _layer$dataView;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: 'tokenGeo'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: (_layer$dataView = layer.dataView) !== null && _layer$dataView !== void 0 && _layer$dataView.timeFieldName ? '' : 'subdued'
  }, /*#__PURE__*/_react.default.createElement("h5", null, layer.layerDisplayName))))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    grow: false,
    color: "plain"
  }, layer.dataView && layer.dataView.timeFieldName ? /*#__PURE__*/_react.default.createElement(_compatible_layer.CompatibleLayer, {
    embeddable: embeddable,
    layer: layer,
    layerIndex: layerIndex
  }) : /*#__PURE__*/_react.default.createElement(_incompatible_layer.IncompatibleLayer, {
    noDataView: layer.dataView === undefined
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
};
exports.Layer = Layer;