"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCssMlExplorerChartContainer = exports.cssMlExplorerChart = void 0;
var _react = require("@emotion/react");
var _eui = require("@elastic/eui");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCssMlExplorerChartContainer = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const euiFontSizeXS = (0, _eui.useEuiFontSize)('xs').fontSize;
  return (0, _react.css)({
    overflow: 'hidden',
    '.ml-explorer-chart-svg': {
      fontSize: euiFontSizeXS,
      fontFamily: euiTheme.font.family,
      '.line-chart': {
        rect: {
          fill: euiTheme.colors.emptyShade,
          opacity: 1
        },
        'rect.selected-interval': {
          fill: (0, _eui.transparentize)('#c8c8c8', 0.1),
          stroke: euiTheme.colors.darkShade,
          strokeWidth: (0, _eui.mathWithUnits)(euiTheme.size.xs, x => x / 2),
          strokeOpacity: 0.8
        },
        'rect.scheduled-event-marker': {
          strokeWidth: '1px',
          stroke: euiTheme.colors.darkShade,
          fill: euiTheme.colors.lightShade,
          pointerEvents: 'none'
        }
      }
    },
    '.axis path, .axis line': {
      fill: 'none',
      stroke: euiTheme.border.color,
      shapeRendering: 'crispEdges'
    },
    '.axis .tick line.ml-tick-emphasis': {
      stroke: (0, _eui.transparentize)('#000', 0.2)
    },
    '.axis text': {
      fill: euiTheme.colors.lightShade
    },
    '.axis .tick line': {
      stroke: euiTheme.colors.lightShade,
      strokeWidth: '1px'
    },
    '.values-line': {
      fill: 'none',
      stroke: euiTheme.colors.primary,
      strokeWidth: '2px'
    },
    '.values-dots circle, .values-dots-circle': {
      fill: euiTheme.colors.primary,
      strokeWidth: 0
    },
    '.values-dots circle.values-dots-circle-blur': {
      fill: euiTheme.colors.mediumShade
    },
    '.metric-value': {
      opacity: 1,
      fill: 'transparent',
      stroke: euiTheme.colors.primary,
      strokeWidth: 0
    },
    '.anomaly-marker': {
      strokeWidth: '1px',
      stroke: euiTheme.colors.mediumShade
    },
    '.anomaly-marker:hover': {
      strokeWidth: '6px',
      stroke: euiTheme.colors.primary
    },
    '.anomaly-marker.critical': {
      fill: _mlAnomalyUtils.ML_SEVERITY_COLORS.CRITICAL
    },
    '.anomaly-marker.major': {
      fill: _mlAnomalyUtils.ML_SEVERITY_COLORS.MAJOR
    },
    '.anomaly-marker.minor': {
      fill: _mlAnomalyUtils.ML_SEVERITY_COLORS.MINOR
    },
    '.anomaly-marker.warning': {
      fill: _mlAnomalyUtils.ML_SEVERITY_COLORS.WARNING
    },
    '.anomaly-marker.low': {
      fill: _mlAnomalyUtils.ML_SEVERITY_COLORS.LOW
    },
    '.metric-value:hover, .anomaly-marker:hover': {
      strokeWidth: '6px',
      strokeOpacity: 0.65
    },
    'ml-explorer-chart-axis-emphasis': {
      fontWeight: 'bold'
    }
  });
};
exports.useCssMlExplorerChartContainer = useCssMlExplorerChartContainer;
const cssMlExplorerChart = exports.cssMlExplorerChart = (0, _react.css)({
  overflow: 'hidden'
});