"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyticsEmptyPrompt = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _data_frame_analytics_kibana = _interopRequireDefault(require("./data_frame_analytics_kibana.png"));
var _ml_nodes_check = require("../../../../../ml_nodes_check");
var _kibana = require("../../../../../contexts/kibana");
var _locator = require("../../../../../../../common/constants/locator");
var _check_capabilities = require("../../../../../capabilities/check_capabilities");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AnalyticsEmptyPrompt = () => {
  const {
    services: {
      docLinks
    }
  } = (0, _kibana.useMlKibana)();
  const [canCreateDataFrameAnalytics, canStartStopDataFrameAnalytics] = (0, _check_capabilities.usePermissionCheck)(['canCreateDataFrameAnalytics', 'canStartStopDataFrameAnalytics']);
  const disabled = !(0, _ml_nodes_check.mlNodesAvailable)() || !canCreateDataFrameAnalytics || !canStartStopDataFrameAnalytics;
  const navigateToPath = (0, _kibana.useNavigateToPath)();
  const navigateToSourceSelection = async () => {
    await navigateToPath(_locator.ML_PAGES.DATA_FRAME_ANALYTICS_SOURCE_SELECTION);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    layout: "horizontal",
    hasBorder: false,
    hasShadow: false,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
      size: "fullWidth",
      src: _data_frame_analytics_kibana.default,
      alt: _i18n.i18n.translate('xpack.ml.dataFrame.analyticsList.emptyPromptTitle', {
        defaultMessage: 'Analyze your data with data frame analytics'
      })
    }),
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataFrame.analyticsList.emptyPromptTitle",
      defaultMessage: "Analyze your data with data frame analytics"
    })),
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.overview.analyticsList.emptyPromptText",
      defaultMessage: "Train outlier detection, regression, or classification machine learning models using data frame analytics."
    }))),
    actions: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: navigateToSourceSelection,
      isDisabled: disabled,
      color: "primary",
      "data-test-subj": "mlAnalyticsCreateFirstButton"
    }, _i18n.i18n.translate('xpack.ml.dataFrame.analyticsList.emptyPromptButtonText', {
      defaultMessage: 'Create data frame analytics job'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: docLinks.links.ml.dataFrameAnalytics,
      target: "_blank",
      external: true
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.common.readDocumentationLink",
      defaultMessage: "Read documentation"
    }))],
    "data-test-subj": "mlNoDataFrameAnalyticsFound"
  });
};
exports.AnalyticsEmptyPrompt = AnalyticsEmptyPrompt;