"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexPermissionsCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _kibana = require("../../../../contexts/kibana");
var _hooks = require("../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IndexPermissionsCallout = ({
  indexName,
  docsType
}) => {
  const {
    services: {
      docLinks: {
        links: {
          ml: {
            dFAStartJob,
            dFACreateJob
          }
        }
      }
    }
  } = (0, _kibana.useMlKibana)();
  const docsLink = docsType === 'start' ? dFAStartJob : dFACreateJob;
  const hasRequiredIndicesPermissions = (0, _hooks.useHasRequiredIndicesPermissions)(indexName, docsType === 'start');
  // If 'hasRequiredIndicesPermissions' is undefined - the index passed to the check is an empty string
  if (hasRequiredIndicesPermissions === undefined || hasRequiredIndicesPermissions === true) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.permissionsCalloutTitle', {
      defaultMessage: 'Indices permissions required'
    }),
    iconType: "warning",
    color: "warning"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataframe.analytics.create.indicesPermissionsMessage",
    defaultMessage: "You don't have the required permissions on the {indexName} index. Refer to the {docLink} for more information on requirements.",
    values: {
      indexName,
      docLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docsLink,
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.dataframe.analytics.create.indicesPermissionsMessage.docsLink",
        defaultMessage: "documentation"
      }))
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
};
exports.IndexPermissionsCallout = IndexPermissionsCallout;