"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CannotReadFileCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CannotReadFileCallout = () => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.ml.importExport.importFlyout.cannotReadFileCallout.title', {
      defaultMessage: 'File cannot be read'
    }),
    color: "warning"
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "mlJobMgmtImportJobsFileReadErrorCallout"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.importExport.importFlyout.cannotReadFileCallout.body",
    defaultMessage: "Please select a file contained Machine Learning jobs which have been exported from Kibana using the Export Jobs option"
  }))));
};
exports.CannotReadFileCallout = CannotReadFileCallout;