"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeDataViews = initializeDataViews;
var _rxjs = require("rxjs");
var _lodash = require("lodash");
var _actions = require("../actions");
var _index_pattern_util = require("../index_pattern_util");
var _map_selectors = require("../selectors/map_selectors");
var _data_request_actions = require("../actions/data_request_actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function initializeDataViews(store) {
  const dataViews$ = new _rxjs.BehaviorSubject(undefined);
  let dataViewsFetchToken;
  async function updateDataViews() {
    var _dataViews$$getValue;
    const queryableDataViewIds = (0, _map_selectors.getQueryableUniqueIndexPatternIds)(store.getState());
    const prevDataViewIds = (_dataViews$$getValue = dataViews$.getValue()) === null || _dataViews$$getValue === void 0 ? void 0 : _dataViews$$getValue.map(dataView => {
      return dataView.id;
    });
    if ((0, _lodash.isEqual)(queryableDataViewIds.sort(), prevDataViewIds === null || prevDataViewIds === void 0 ? void 0 : prevDataViewIds.sort())) {
      return;
    }
    const currentDataViewsFetchToken = Symbol();
    dataViewsFetchToken = currentDataViewsFetchToken;
    const dataViews = await (0, _index_pattern_util.getIndexPatternsFromIds)(queryableDataViewIds);
    // ignore responses from obsolete requests
    if (currentDataViewsFetchToken !== dataViewsFetchToken) {
      return;
    }
    dataViews$.next(dataViews);
  }
  updateDataViews();
  const syncLayerTokens = {};
  return {
    dataViews$,
    setLayerList(layerList) {
      store.dispatch((0, _actions.replaceLayerList)(layerList));
      updateDataViews();
    },
    updateLayerById: layerDescriptor => {
      store.dispatch((0, _actions.updateLayerDescriptor)(layerDescriptor));
      updateDataViews();
      (async () => {
        const currentSyncLayerToken = Symbol();
        syncLayerTokens[layerDescriptor.id] = currentSyncLayerToken;
        await store.dispatch((0, _data_request_actions.syncDataForLayerId)(layerDescriptor.id, false));
        // stop processing responses from obsolete requests
        if (currentSyncLayerToken !== syncLayerTokens[layerDescriptor.id]) {
          return;
        }
        if ((0, _map_selectors.getMapSettings)(store.getState()).autoFitToDataBounds) {
          store.dispatch((0, _data_request_actions.autoFitToBounds)());
        }
      })();
    }
  };
}