"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ScaleControl = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_WIDTH = 110;
function getScaleDistance(value) {
  const orderOfMagnitude = Math.floor(Math.log10(value));
  const pow10 = Math.pow(10, orderOfMagnitude);

  // reduce value to single order of magnitude to making rounding simple regardless of order of magnitude
  const distance = value / pow10;
  if (distance < 1) {
    return pow10 * (Math.round(distance * 10) / 10);
  }

  // provide easy to multiple round numbers for scale distance so its easy to measure distances longer then the scale
  if (distance >= 10) {
    return 10 * pow10;
  }
  if (distance >= 5) {
    return 5 * pow10;
  }
  if (distance >= 3) {
    return 3 * pow10;
  }
  return Math.floor(distance) * pow10;
}
class ScaleControl extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "state", {
      label: '',
      width: 0
    });
    (0, _defineProperty2.default)(this, "_onUpdate", () => {
      if (!this._isMounted) {
        return;
      }
      const centerHeight = this.props.mbMap.getContainer().clientHeight / 2;
      const leftLatLon = this.props.mbMap.unproject([0, centerHeight]);
      const rightLatLon = this.props.mbMap.unproject([MAX_WIDTH, centerHeight]);
      const maxDistanceMeters = leftLatLon.distanceTo(rightLatLon);
      if (maxDistanceMeters >= 1000) {
        this._setScale(maxDistanceMeters / 1000, _i18n.i18n.translate('xpack.maps.kilometersAbbr', {
          defaultMessage: 'km'
        }));
      } else {
        this._setScale(maxDistanceMeters, _i18n.i18n.translate('xpack.maps.metersAbbr', {
          defaultMessage: 'm'
        }));
      }
    });
  }
  componentDidMount() {
    this._isMounted = true;
    this.props.mbMap.on('move', this._onUpdate);
    this._onUpdate();
  }
  componentWillUnmount() {
    this._isMounted = false;
    this.props.mbMap.off('move', this._onUpdate);
  }
  _setScale(maxDistance, unit) {
    const scaleDistance = getScaleDistance(maxDistance);
    const zoom = this.props.mbMap.getZoom();
    const bounds = this.props.mbMap.getBounds();
    let label = `${scaleDistance} ${unit}`;
    if (zoom <= 4 || zoom <= 6 && (bounds.getNorth() > 23.5 || bounds.getSouth() < -23.5) || zoom <= 8 && (bounds.getNorth() > 45 || bounds.getSouth() < -45)) {
      label = '~' + label;
    }
    this.setState({
      width: MAX_WIDTH * (scaleDistance / maxDistance),
      label
    });
  }
  render() {
    return /*#__PURE__*/_react.default.createElement("div", {
      className: (0, _classnames.default)('mapScaleControl', {
        mapScaleControlFullScreen: this.props.isFullScreen
      }),
      style: {
        width: `${this.state.width}px`
      }
    }, this.state.label);
  }
}
exports.ScaleControl = ScaleControl;