"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManagementSection = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _management_item = require("./management_item");
var _management_app = require("./management_app");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class ManagementSection extends _management_item.ManagementItem {
  constructor(args) {
    super(args);
    (0, _defineProperty2.default)(this, "apps", []);
  }
  registerApp(args) {
    if (this.getApp(args.id)) {
      throw new Error(`Management app already registered - id: ${args.id}, title: ${args.title}`);
    }
    const app = new _management_app.ManagementApp({
      ...args,
      basePath: `/${this.id}/${args.id}`
    });
    this.apps.push(app);
    return app;
  }
  getApp(id) {
    return this.apps.find(app => app.id === id);
  }
  getAppsEnabled() {
    return this.apps.filter(app => app.enabled);
  }
}
exports.ManagementSection = ManagementSection;