"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.logEntryHitRT = exports.getLogEntryResponseRT = exports.createGetLogEntryQuery = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _typed_json = require("../../../../common/typed_json");
var _elasticsearch_runtime_types = require("../../../utils/elasticsearch_runtime_types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createGetLogEntryQuery = (logEntryIndex, logEntryId, timestampField, tiebreakerField, runtimeMappings) => ({
  index: logEntryIndex,
  body: {
    size: 1,
    terminate_after: 1,
    track_scores: false,
    track_total_hits: false,
    query: {
      ids: {
        values: [logEntryId]
      }
    },
    fields: ['*'],
    runtime_mappings: runtimeMappings,
    sort: [{
      [timestampField]: {
        order: 'desc',
        format: 'strict_date_optional_time_nanos',
        numeric_type: 'date_nanos'
      }
    }, {
      [tiebreakerField]: 'desc'
    }],
    _source: false
  }
});
exports.createGetLogEntryQuery = createGetLogEntryQuery;
const logEntryHitRT = exports.logEntryHitRT = rt.intersection([_elasticsearch_runtime_types.commonHitFieldsRT, rt.type({
  sort: rt.tuple([rt.string, rt.number])
}), rt.partial({
  fields: rt.record(rt.string, _typed_json.jsonArrayRT)
})]);
const getLogEntryResponseRT = exports.getLogEntryResponseRT = rt.intersection([_elasticsearch_runtime_types.commonSearchSuccessResponseFieldsRT, rt.type({
  hits: rt.type({
    hits: rt.array(logEntryHitRT)
  })
})]);