"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupOfGroups = void 0;
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
var _group_name = require("./group_name");
var _group_of_nodes = require("./group_of_nodes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GroupOfGroups = props => {
  return /*#__PURE__*/_react.default.createElement(GroupOfGroupsContainer, null, /*#__PURE__*/_react.default.createElement(_group_name.GroupName, {
    group: props.group,
    onDrilldown: props.onDrilldown,
    options: props.options,
    nodeType: props.nodeType
  }), /*#__PURE__*/_react.default.createElement(Groups, null, props.group.groups.map(group => /*#__PURE__*/_react.default.createElement(_group_of_nodes.GroupOfNodes, {
    isChild: true,
    key: group.id,
    onDrilldown: props.onDrilldown,
    options: props.options,
    group: group,
    formatter: props.formatter,
    bounds: props.bounds,
    nodeType: props.nodeType,
    currentTime: props.currentTime,
    detailsItemId: props.detailsItemId
  }))));
};
exports.GroupOfGroups = GroupOfGroups;
const GroupOfGroupsContainer = _common.euiStyled.div`
  margin: 0 10px;
  width: 100%;
`;
const Groups = _common.euiStyled.div`
  display: flex;
  background-color: rgba(0, 0, 0, 0.05);
  flex-wrap: wrap;
  justify-content: center;
  padding: 20px 10px 10px;
  border-radius: 4px;
  border: 1px solid ${props => props.theme.eui.euiBorderColor};
  box-shadow: 0 1px 7px rgba(0, 0, 0, 0.1);
`;