"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLogEntryRateSetupContext = exports.useLogEntryRateSetup = exports.LogEntryRateSetupProvider = void 0;
var _constate = _interopRequireDefault(require("constate"));
var _log_analysis_setup_state = require("../../log_analysis_setup_state");
var _use_log_entry_rate_module = require("./use_log_entry_rate_module");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLogEntryRateSetup = () => {
  const {
    cleanUpAndSetUpModule,
    lastSetupErrorMessages,
    moduleDescriptor,
    setUpModule,
    setupStatus,
    sourceConfiguration,
    viewResults
  } = (0, _use_log_entry_rate_module.useLogEntryRateModuleContext)();
  const {
    cleanUpAndSetUp,
    endTime,
    isValidating,
    setEndTime,
    setStartTime,
    setValidatedIndices,
    setUp,
    startTime,
    validatedIndices,
    validationErrors
  } = (0, _log_analysis_setup_state.useAnalysisSetupState)({
    cleanUpAndSetUpModule,
    moduleDescriptor,
    setUpModule,
    sourceConfiguration
  });
  return {
    cleanUpAndSetUp,
    endTime,
    isValidating,
    lastSetupErrorMessages,
    moduleDescriptor,
    setEndTime,
    setStartTime,
    setValidatedIndices,
    setUp,
    setupStatus,
    startTime,
    validatedIndices,
    validationErrors,
    viewResults
  };
};
exports.useLogEntryRateSetup = useLogEntryRateSetup;
const [LogEntryRateSetupProvider, useLogEntryRateSetupContext] = (0, _constate.default)(useLogEntryRateSetup);
exports.useLogEntryRateSetupContext = useLogEntryRateSetupContext;
exports.LogEntryRateSetupProvider = LogEntryRateSetupProvider;