"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAutoUpgradeAgentsStatus = getAutoUpgradeAgentsStatus;
var _pMap = _interopRequireDefault(require("p-map"));
var _common = require("../../../common");
var _services = require("../../../common/services");
var _app_context = require("../app_context");
var _actions = require("./actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_CONCURRENT_AGENT_POLICIES_OPERATIONS_20 = 20;
async function getAutoUpgradeAgentsStatus(agentClient, agentPolicyId) {
  const currentVersionsMap = {};
  let total = 0;
  await agentClient.listAgents({
    showInactive: false,
    perPage: 0,
    kuery: `${_services.AgentStatusKueryHelper.buildKueryForActiveAgents()} AND ${_common.AGENTS_PREFIX}.policy_id:"${agentPolicyId}"`,
    aggregations: {
      versions: {
        terms: {
          field: 'agent.version',
          size: 1000
        }
      }
    }
  }).then(result => {
    var _result$aggregations, _result$aggregations$;
    (_result$aggregations = result.aggregations) === null || _result$aggregations === void 0 ? void 0 : (_result$aggregations$ = _result$aggregations.versions) === null || _result$aggregations$ === void 0 ? void 0 : _result$aggregations$.buckets.forEach(bucket => currentVersionsMap[bucket.key] = {
      version: bucket.key,
      agents: bucket.doc_count,
      failedUpgradeAgents: 0,
      inProgressUpgradeAgents: 0
    });
    total = result.total;
  });
  await agentClient.listAgents({
    showInactive: false,
    perPage: 0,
    kuery: `${_services.AgentStatusKueryHelper.buildKueryForActiveAgents()} AND ${_common.AGENTS_PREFIX}.policy_id:"${agentPolicyId}" AND ${_common.AGENTS_PREFIX}.upgrade_details.state:"UPG_FAILED"`,
    aggregations: {
      action_id_versions: {
        multi_terms: {
          terms: [{
            field: 'upgrade_details.target_version.keyword'
          }, {
            field: 'upgrade_details.action_id'
          }],
          size: 1000
        }
      }
    }
  }).then(async result => {
    var _result$aggregations2, _buckets, _result$aggregations$2;
    if (!((_result$aggregations2 = result.aggregations) !== null && _result$aggregations2 !== void 0 && _result$aggregations2.action_id_versions)) {
      return;
    }
    const actionCacheIsAutomatic = new Map();
    await (0, _pMap.default)((_buckets = (_result$aggregations$2 = result.aggregations.action_id_versions) === null || _result$aggregations$2 === void 0 ? void 0 : _result$aggregations$2.buckets) !== null && _buckets !== void 0 ? _buckets : [], async bucket => {
      const version = bucket.key[0];
      const actionId = bucket.key[1];
      let isAutomatic = actionCacheIsAutomatic.get(actionId);
      if (isAutomatic === undefined) {
        var _actions$some;
        const actions = await (0, _actions.getAgentActions)(_app_context.appContextService.getInternalUserESClient(), actionId);
        isAutomatic = (_actions$some = actions === null || actions === void 0 ? void 0 : actions.some(action => action.is_automatic)) !== null && _actions$some !== void 0 ? _actions$some : false;
        actionCacheIsAutomatic.set(actionId, isAutomatic);
      }
      if (isAutomatic) {
        if (!currentVersionsMap[version]) {
          currentVersionsMap[version] = {
            version,
            agents: 0,
            failedUpgradeAgents: 0,
            inProgressUpgradeAgents: 0
          };
        }
        currentVersionsMap[version].failedUpgradeAgents += bucket.doc_count;
        if (!currentVersionsMap[version].failedUpgradeActionIds) {
          currentVersionsMap[version].failedUpgradeActionIds = [];
        }
        currentVersionsMap[version].failedUpgradeActionIds.push(actionId);
      }
    }, {
      concurrency: MAX_CONCURRENT_AGENT_POLICIES_OPERATIONS_20
    });
  });
  await agentClient.listAgents({
    showInactive: false,
    perPage: 0,
    kuery: `${_services.AgentStatusKueryHelper.buildKueryForActiveAgents()} AND ${_common.AGENTS_PREFIX}.policy_id:"${agentPolicyId}" AND ${_common.AGENTS_PREFIX}.upgrade_details.state:* AND not ${_common.AGENTS_PREFIX}.upgrade_details.state:"UPG_FAILED"`,
    aggregations: {
      action_id_versions: {
        multi_terms: {
          terms: [{
            field: 'agent.version'
          }, {
            field: 'upgrade_details.target_version.keyword'
          }, {
            field: 'upgrade_details.action_id'
          }],
          size: 1000
        }
      }
    }
  }).then(async result => {
    var _result$aggregations3, _buckets2, _result$aggregations$3;
    if (!((_result$aggregations3 = result.aggregations) !== null && _result$aggregations3 !== void 0 && _result$aggregations3.action_id_versions)) {
      return;
    }
    const actionCacheIsAutomatic = new Map();
    await (0, _pMap.default)((_buckets2 = (_result$aggregations$3 = result.aggregations.action_id_versions) === null || _result$aggregations$3 === void 0 ? void 0 : _result$aggregations$3.buckets) !== null && _buckets2 !== void 0 ? _buckets2 : [], async bucket => {
      const agentVersion = bucket.key[0];
      const targetVersion = bucket.key[1];
      const actionId = bucket.key[2];

      // Count as success
      if (agentVersion === targetVersion) {
        return;
      }
      let isAutomatic = actionCacheIsAutomatic.get(actionId);
      if (isAutomatic === undefined) {
        var _actions$some2;
        const actions = await (0, _actions.getAgentActions)(_app_context.appContextService.getInternalUserESClient(), actionId);
        isAutomatic = (_actions$some2 = actions === null || actions === void 0 ? void 0 : actions.some(action => action.is_automatic)) !== null && _actions$some2 !== void 0 ? _actions$some2 : false;
        actionCacheIsAutomatic.set(actionId, isAutomatic);
      }
      if (isAutomatic) {
        if (!currentVersionsMap[targetVersion]) {
          currentVersionsMap[targetVersion] = {
            version: targetVersion,
            agents: 0,
            failedUpgradeAgents: 0,
            inProgressUpgradeAgents: 0
          };
        }
        currentVersionsMap[targetVersion].inProgressUpgradeAgents += bucket.doc_count;
        if (!currentVersionsMap[targetVersion].inProgressUpgradeActionIds) {
          currentVersionsMap[targetVersion].inProgressUpgradeActionIds = [];
        }
        currentVersionsMap[targetVersion].inProgressUpgradeActionIds.push(actionId);
      }
    }, {
      concurrency: MAX_CONCURRENT_AGENT_POLICIES_OPERATIONS_20
    });
  });
  return {
    currentVersions: Object.values(currentVersionsMap),
    totalAgents: total
  };
}