"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentPolicyAdvancedOptionsContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _missing_privileges_tooltip = require("../../../../../../components/missing_privileges_tooltip");
var _constants = require("../../../../../../../common/constants");
var _hooks = require("../../../../hooks");
var _components = require("../../../../components");
var _components2 = require("../../../../../../components");
var _services = require("../../../../services");
var _agent_policy_form = require("../agent_policy_form");
var _services2 = require("../../../../../../../common/services");
var _hooks2 = require("./hooks");
var _custom_fields = require("./custom_fields");
var _space_selector = require("./space_selector");
var _advanced_monitoring = require("./advanced_monitoring");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AgentPolicyAdvancedOptionsContent = ({
  agentPolicy,
  updateAgentPolicy,
  validation,
  disabled = false
}) => {
  var _config$developer$max, _config$developer, _agentPoliciesData$to, _agentPolicy$agent_fe;
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  const {
    spaceId,
    isSpaceAwarenessEnabled
  } = (0, _hooks.useFleetStatus)();
  const {
    getAbsolutePath
  } = (0, _hooks.useLink)();
  const AgentTamperProtectionWrapper = (0, _hooks.useUIExtension)('endpoint', 'endpoint-agent-tamper-protection');
  const config = (0, _hooks.useConfig)();
  const authz = (0, _hooks.useAuthz)();
  const maxAgentPoliciesWithInactivityTimeout = (_config$developer$max = (_config$developer = config.developer) === null || _config$developer === void 0 ? void 0 : _config$developer.maxAgentPoliciesWithInactivityTimeout) !== null && _config$developer$max !== void 0 ? _config$developer$max : _constants.DEFAULT_MAX_AGENT_POLICIES_WITH_INACTIVITY_TIMEOUT;
  const [touchedFields, setTouchedFields] = (0, _react.useState)({});
  const {
    dataOutputOptions,
    monitoringOutputOptions,
    isLoading: isLoadingOptions
  } = (0, _hooks2.useOutputOptions)(agentPolicy);
  const {
    data: agentPoliciesData
  } = (0, _hooks.useGetAgentPolicies)({
    page: 1,
    perPage: 0,
    kuery: `${_constants.LEGACY_AGENT_POLICY_SAVED_OBJECT_TYPE}.inactivity_timeout:*`
  });
  const totalAgentPoliciesWithInactivityTimeout = (_agentPoliciesData$to = agentPoliciesData === null || agentPoliciesData === void 0 ? void 0 : agentPoliciesData.total) !== null && _agentPoliciesData$to !== void 0 ? _agentPoliciesData$to : 0;
  const tooManyAgentPoliciesForInactivityTimeout = maxAgentPoliciesWithInactivityTimeout !== undefined && totalAgentPoliciesWithInactivityTimeout > (maxAgentPoliciesWithInactivityTimeout !== null && maxAgentPoliciesWithInactivityTimeout !== void 0 ? maxAgentPoliciesWithInactivityTimeout : 0);
  const {
    dataDownloadSourceOptions,
    isLoading: isLoadingDownloadSources
  } = (0, _hooks2.useDownloadSourcesOptions)();
  const {
    fleetServerHostsOptions,
    isLoading: isLoadingFleetServerHostsOption
  } = (0, _hooks2.useFleetServerHostsOptions)(agentPolicy);

  // agent monitoring checkbox group can appear multiple times in the DOM, ids have to be unique to work correctly
  const monitoringCheckboxIdSuffix = Date.now();
  const {
    agentTamperProtectionEnabled
  } = _services.ExperimentalFeaturesService.get();
  const licenseService = (0, _hooks.useLicense)();
  const [isUninstallCommandFlyoutOpen, setIsUninstallCommandFlyoutOpen] = (0, _react.useState)(false);
  const policyHasElasticDefend = (0, _react.useMemo)(() => (0, _services2.policyHasEndpointSecurity)(agentPolicy), [agentPolicy]);
  const isManagedPolicy = agentPolicy.is_managed === true;
  const isManagedorAgentlessPolicy = isManagedPolicy || (agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.supports_agentless) === true;
  const userHasAccessToAllPolicySpaces = (0, _react.useMemo)(() => {
    var _agentPolicy$space_id;
    return 'space_ids' in agentPolicy ? !((_agentPolicy$space_id = agentPolicy.space_ids) !== null && _agentPolicy$space_id !== void 0 && _agentPolicy$space_id.includes(_constants.UNKNOWN_SPACE)) : true;
  }, [agentPolicy]);
  const agentPolicyFormContext = (0, _agent_policy_form.useAgentPolicyFormContext)();
  const AgentTamperProtectionSectionContent = (0, _react.useMemo)(() => {
    var _agentPolicy$is_prote;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
      fullWidth: true,
      title: /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentPolicyForm.tamperingLabel",
        defaultMessage: "Agent tamper protection"
      })),
      description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentPolicyForm.tamperingDescription",
        defaultMessage: "Prevent agents from being uninstalled locally. When enabled, agents can only be uninstalled using an authorization token in the uninstall command. Click { linkName } for the full command.",
        values: {
          linkName: /*#__PURE__*/_react.default.createElement("strong", null, "Get uninstall command")
        }
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentPolicyForm.tamperingSwitchLabel",
        defaultMessage: "Prevent agent tampering"
      }), ' ', !policyHasElasticDefend && /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "tamperMissingIntegrationTooltip"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        type: "info",
        color: "subdued",
        content: _i18n.i18n.translate('xpack.fleet.agentPolicyForm.tamperingSwitchLabel.disabledWarning', {
          defaultMessage: 'Elastic Defend integration is required to enable this feature'
        })
      }))),
      checked: (_agentPolicy$is_prote = agentPolicy.is_protected) !== null && _agentPolicy$is_prote !== void 0 ? _agentPolicy$is_prote : false,
      onChange: e => {
        updateAgentPolicy({
          is_protected: e.target.checked
        });
      },
      disabled: disabled || !policyHasElasticDefend,
      "data-test-subj": "tamperProtectionSwitch"
    }), agentPolicy.id && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_missing_privileges_tooltip.MissingPrivilegesToolTip, {
      missingPrivilege: policyHasElasticDefend && agentPolicy.is_protected && !authz.fleet.allAgents ? 'Agents All' : undefined,
      position: "left"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: () => {
        setIsUninstallCommandFlyoutOpen(true);
      },
      disabled: !agentPolicy.is_protected || !policyHasElasticDefend || !authz.fleet.allAgents,
      "data-test-subj": "uninstallCommandLink"
    }, _i18n.i18n.translate('xpack.fleet.agentPolicyForm.tamperingUninstallLink', {
      defaultMessage: 'Get uninstall command'
    })))));
  }, [agentPolicy.id, agentPolicy.is_protected, policyHasElasticDefend, updateAgentPolicy, disabled, authz.fleet.allAgents]);
  const AgentTamperProtectionSection = (0, _react.useMemo)(() => {
    if (agentTamperProtectionEnabled && licenseService.isPlatinum() && !agentPolicy.is_managed && !agentPolicy.supports_agentless) {
      if (AgentTamperProtectionWrapper) {
        return /*#__PURE__*/_react.default.createElement(_react.Suspense, {
          fallback: null
        }, /*#__PURE__*/_react.default.createElement(AgentTamperProtectionWrapper.Component, null, AgentTamperProtectionSectionContent));
      }
      return AgentTamperProtectionSectionContent;
    }
  }, [agentTamperProtectionEnabled, licenseService, agentPolicy.is_managed, AgentTamperProtectionWrapper, AgentTamperProtectionSectionContent, agentPolicy.supports_agentless]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.descriptionFieldLabel",
      defaultMessage: "Description"
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.descriptionDescription",
      defaultMessage: "Add a description of how this policy will be used."
    })
  }, isUninstallCommandFlyoutOpen && agentPolicy.id && /*#__PURE__*/_react.default.createElement(_components2.UninstallCommandFlyout, {
    target: "agent",
    policyId: agentPolicy.id,
    onClose: () => setIsUninstallCommandFlyoutOpen(false)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    key: "description",
    error: touchedFields.description && validation.description ? validation.description : null,
    isDisabled: disabled,
    isInvalid: Boolean(touchedFields.description && validation.description)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    disabled: disabled || agentPolicy.is_managed === true,
    fullWidth: true,
    value: agentPolicy.description,
    onChange: e => updateAgentPolicy({
      description: e.target.value
    }),
    isInvalid: Boolean(touchedFields.description && validation.description),
    onBlur: () => setTouchedFields({
      ...touchedFields,
      description: true
    }),
    placeholder: _i18n.i18n.translate('xpack.fleet.agentPolicyForm.descriptionFieldPlaceholder', {
      defaultMessage: 'Optional description'
    })
  }))), isSpaceAwarenessEnabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.spaceFieldLabel",
      defaultMessage: "Spaces"
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.spaceDescription",
      defaultMessage: "Select one or more spaces for this policy or create a new one. {link}{tooltip}",
      values: {
        link: userHasAccessToAllPolicySpaces && /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          target: "_blank",
          href: getAbsolutePath('/app/management/kibana/spaces/create'),
          external: true,
          "data-test-subj": "spaceSelectorInputLink"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.agentPolicyForm.createSpaceLink",
          defaultMessage: "Create space"
        })),
        tooltip: !userHasAccessToAllPolicySpaces && /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
          type: "info",
          color: "subdued",
          content: _i18n.i18n.translate('xpack.fleet.agentPolicyForm.spaceTooltip', {
            defaultMessage: 'Access to all policy spaces is required for edit.'
          })
        })
      }
    }),
    "data-test-subj": "spaceSelectorInput"
  }, /*#__PURE__*/_react.default.createElement(_space_selector.SpaceSelector, {
    isDisabled: disabled || agentPolicy.is_managed === true || !userHasAccessToAllPolicySpaces,
    value: 'space_ids' in agentPolicy && agentPolicy.space_ids ? agentPolicy.space_ids.filter(id => id !== _constants.UNKNOWN_SPACE) : [spaceId || 'default'],
    setInvalidSpaceError: agentPolicyFormContext === null || agentPolicyFormContext === void 0 ? void 0 : agentPolicyFormContext.setInvalidSpaceError,
    onChange: newValue => {
      if (newValue.length === 0) {
        return;
      }
      updateAgentPolicy({
        space_ids: newValue
      });
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement("h3", {
      "data-test-subj": "defaultNamespaceHeader"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.namespaceFieldLabel",
      defaultMessage: "Default namespace"
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.namespaceFieldDescription",
      defaultMessage: "Namespaces are a user-configurable arbitrary grouping that makes it easier to search for data and manage user permissions. A policy namespace is used to name its integration's data streams. {fleetUserGuide}.",
      values: {
        fleetUserGuide: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: docLinks.links.fleet.datastreamsNamingScheme,
          target: "_blank"
        }, _i18n.i18n.translate('xpack.fleet.agentPolicyForm.nameSpaceFieldDescription.fleetUserGuideLabel', {
          defaultMessage: 'Learn more'
        }))
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    error: validation.namespace ? validation.namespace : null,
    isInvalid: Boolean(validation.namespace),
    isDisabled: disabled
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    singleSelection: true,
    noSuggestions: true,
    isDisabled: disabled,
    selectedOptions: agentPolicy.namespace ? [{
      label: agentPolicy.namespace
    }] : [],
    onCreateOption: value => {
      updateAgentPolicy({
        namespace: value
      });
    },
    onChange: selectedOptions => {
      updateAgentPolicy({
        namespace: selectedOptions.length ? selectedOptions[0] : ''
      });
    },
    isInvalid: Boolean(touchedFields.namespace && validation.namespace),
    onBlur: () => setTouchedFields({
      ...touchedFields,
      namespace: true
    })
  }))), /*#__PURE__*/_react.default.createElement(_custom_fields.CustomFields, {
    updateAgentPolicy: updateAgentPolicy,
    agentPolicy: agentPolicy,
    isDisabled: disabled || agentPolicy.is_managed === true
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.monitoringLabel",
      defaultMessage: "Agent monitoring"
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.monitoringDescription",
      defaultMessage: "Collecting monitoring logs and metrics will also create an {agent} integration. Monitoring data will be written to the default namespace specified above.",
      values: {
        agent: /*#__PURE__*/_react.default.createElement(_components.AgentPolicyPackageBadge, {
          pkgName: 'elastic_agent',
          pkgTitle: 'Elastic Agent'
        })
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCheckboxGroup, {
    disabled: disabled || isManagedorAgentlessPolicy,
    options: [{
      id: `${_constants.dataTypes.Logs}_${monitoringCheckboxIdSuffix}`,
      'data-test-subj': 'collectLogsCheckbox',
      label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentPolicyForm.monitoringLogsFieldLabel",
        defaultMessage: "Collect agent logs"
      }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        content: _i18n.i18n.translate('xpack.fleet.agentPolicyForm.monitoringLogsTooltipText', {
          defaultMessage: 'Collect logs from Elastic Agents that use this policy.'
        }),
        position: "right",
        type: "info",
        color: "subdued"
      }))
    }, {
      id: `${_constants.dataTypes.Metrics}_${monitoringCheckboxIdSuffix}`,
      'data-test-subj': 'collectMetricsCheckbox',
      label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentPolicyForm.monitoringMetricsFieldLabel",
        defaultMessage: "Collect agent metrics"
      }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        content: _i18n.i18n.translate('xpack.fleet.agentPolicyForm.monitoringMetricsTooltipText', {
          defaultMessage: 'Collect metrics from Elastic Agents that use this policy.'
        }),
        position: "right",
        type: "info",
        color: "subdued"
      }))
    }],
    idToSelectedMap: (agentPolicy.monitoring_enabled || []).reduce((acc, key) => {
      acc[`${key}_${monitoringCheckboxIdSuffix}`] = true;
      return acc;
    }, {
      logs: false,
      metrics: false
    }),
    onChange: longId => {
      const id = longId.split('_')[0];
      if (id !== _constants.dataTypes.Logs && id !== _constants.dataTypes.Metrics) {
        return;
      }
      const hasLogs = agentPolicy.monitoring_enabled && agentPolicy.monitoring_enabled.indexOf(id) >= 0;
      const previousValues = agentPolicy.monitoring_enabled || [];
      updateAgentPolicy({
        monitoring_enabled: hasLogs ? previousValues.filter(type => type !== id) : [...previousValues, id]
      });
    }
  })), /*#__PURE__*/_react.default.createElement(_advanced_monitoring.AgentPolicyAdvancedMonitoringOptions, {
    agentPolicy: agentPolicy,
    disabled: disabled || agentPolicy.is_managed === true,
    validation: validation,
    touchedFields: touchedFields,
    updateTouchedFields: fields => setTouchedFields({
      ...touchedFields,
      ...fields
    }),
    updateAgentPolicy: updateAgentPolicy
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), AgentTamperProtectionSection, /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.inactivityTimeoutLabel",
      defaultMessage: "Inactivity timeout"
    }), tooManyAgentPoliciesForInactivityTimeout && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentPolicyForm.inactivityTimeoutTooltip",
        defaultMessage: "The maximum of 750 agent policies with an inactivity timeout has been exceeded. Remove inactivity timeouts or agent policies to allow agents to become inactive again."
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "warning"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.inactivityTimeoutBadge",
      defaultMessage: "Warning"
    }))))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.inactivityTimeoutDescription",
      defaultMessage: "An optional timeout in seconds. If provided, an agent will automatically change to inactive status and be filtered out of the agents list. A maximum of 750 agent policies can have an inactivity timeout."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    error: touchedFields.inactivity_timeout && validation.inactivity_timeout ? validation.inactivity_timeout : null,
    isInvalid: Boolean(touchedFields.inactivity_timeout && validation.inactivity_timeout),
    isDisabled: disabled
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    fullWidth: true,
    disabled: disabled || isManagedorAgentlessPolicy,
    value: agentPolicy.inactivity_timeout || '',
    min: 0,
    onChange: e => {
      updateAgentPolicy({
        inactivity_timeout: e.target.value ? Number(e.target.value) : 0
      });
    },
    isInvalid: Boolean(touchedFields.inactivity_timeout && validation.inactivity_timeout),
    onBlur: () => setTouchedFields({
      ...touchedFields,
      inactivity_timeout: true
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.fleetServerHostsLabel",
      defaultMessage: "Fleet Server"
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.fleetServerHostsDescripton",
      defaultMessage: "Select to which Fleet Server the agents in this policy will communicate."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    error: touchedFields.fleet_server_host_id && validation.fleet_server_host_id ? validation.fleet_server_host_id : null,
    isDisabled: disabled,
    isInvalid: Boolean(touchedFields.fleet_server_host_id && validation.fleet_server_host_id)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    disabled: disabled || isManagedorAgentlessPolicy,
    valueOfSelected: agentPolicy.fleet_server_host_id || _hooks2.DEFAULT_SELECT_VALUE,
    fullWidth: true,
    isLoading: isLoadingFleetServerHostsOption,
    onChange: e => {
      updateAgentPolicy({
        fleet_server_host_id: e !== _hooks2.DEFAULT_SELECT_VALUE ? e : null
      });
    },
    options: fleetServerHostsOptions
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.dataOutputLabel",
      defaultMessage: "Output for integrations"
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.dataOutputDescription",
      defaultMessage: "Select which output to use for data from integrations."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    error: touchedFields.data_output_id && validation.data_output_id ? validation.data_output_id : null,
    isInvalid: Boolean(touchedFields.data_output_id && validation.data_output_id),
    isDisabled: disabled
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    disabled: disabled || isManagedPolicy,
    valueOfSelected: agentPolicy.data_output_id || _hooks2.DEFAULT_SELECT_VALUE,
    fullWidth: true,
    isLoading: isLoadingOptions,
    onChange: e => {
      updateAgentPolicy({
        data_output_id: e !== _hooks2.DEFAULT_SELECT_VALUE ? e : null
      });
    },
    options: dataOutputOptions
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.monitoringOutputLabel",
      defaultMessage: "Output for agent monitoring"
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.monitoringOutputDescription",
      defaultMessage: "Select which output to use for the agents own monitoring data."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    error: touchedFields.monitoring_output_id && validation.monitoring_output_id ? validation.monitoring_output_id : null,
    isInvalid: Boolean(touchedFields.monitoring_output_id && validation.monitoring_output_id),
    isDisabled: disabled
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    disabled: disabled || isManagedorAgentlessPolicy,
    valueOfSelected: agentPolicy.monitoring_output_id || _hooks2.DEFAULT_SELECT_VALUE,
    fullWidth: true,
    isLoading: isLoadingOptions,
    onChange: e => {
      updateAgentPolicy({
        monitoring_output_id: e !== _hooks2.DEFAULT_SELECT_VALUE ? e : null
      });
    },
    options: monitoringOutputOptions
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.downloadSourceLabel",
      defaultMessage: "Agent binary download",
      "data-test-subj": "agentPolicyForm.downloadSource.label"
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.downloadSourceDescription",
      defaultMessage: "When an upgrade action is issued the agents will download the binary from this location."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    error: touchedFields.download_source_id && validation.download_source_id ? validation.download_source_id : null,
    isInvalid: Boolean(touchedFields.download_source_id && validation.download_source_id),
    isDisabled: disabled
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    disabled: disabled || (agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.supports_agentless) === true,
    valueOfSelected: agentPolicy.download_source_id || _hooks2.DEFAULT_SELECT_VALUE,
    fullWidth: true,
    isLoading: isLoadingDownloadSources,
    onChange: e => {
      updateAgentPolicy({
        download_source_id: e !== _hooks2.DEFAULT_SELECT_VALUE ? e : null
      });
    },
    options: dataDownloadSourceOptions,
    "data-test-subj": "agentPolicyForm.downloadSource.select"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.hostnameFormatLabel",
      defaultMessage: "Host name format"
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.hostnameFormatLabelDescription",
      defaultMessage: "Select how you would like agent domain names to be displayed."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    isDisabled: disabled
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
    disabled: disabled || (agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.supports_agentless) === true,
    options: [{
      id: 'hostname',
      label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "xs",
        direction: "column"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, /*#__PURE__*/_react.default.createElement("b", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentPolicyForm.hostnameFormatOptionHostname",
        defaultMessage: "Hostname"
      })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        color: "subdued"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentPolicyForm.hostnameFormatOptionHostnameExample",
        defaultMessage: "ex: My-Laptop"
      })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s"
      }))
    }, {
      id: 'fqdn',
      label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "xs",
        direction: "column"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, /*#__PURE__*/_react.default.createElement("b", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentPolicyForm.hostnameFormatOptionFqdn",
        defaultMessage: "Fully Qualified Domain Name (FQDN)"
      })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        color: "subdued"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentPolicyForm.hostnameFormatOptionFqdnExample",
        defaultMessage: "ex: My-Laptop.admin.acme.co"
      }))))
    }],
    idSelected: (_agentPolicy$agent_fe = agentPolicy.agent_features) !== null && _agentPolicy$agent_fe !== void 0 && _agentPolicy$agent_fe.length ? 'fqdn' : 'hostname',
    onChange: id => {
      updateAgentPolicy({
        agent_features: id === 'hostname' ? [] : [{
          name: 'fqdn',
          enabled: true
        }]
      });
    },
    name: "radio group"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.unenrollmentTimeoutLabel",
      defaultMessage: "Inactive agent unenrollment timeout"
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.unenrollmentTimeoutDescription",
      defaultMessage: "An optional timeout in seconds. If configured, inactive agents will be automatically unenrolled and their API keys will be invalidated after they've been inactive for this value in seconds. This can be useful for policies containing ephemeral agents, such as those in a Docker or Kubernetes environment."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    error: touchedFields.unenroll_timeout && validation.unenroll_timeout ? validation.unenroll_timeout : null,
    isInvalid: Boolean(touchedFields.unenroll_timeout && validation.unenroll_timeout),
    isDisabled: disabled
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    fullWidth: true,
    disabled: disabled || isManagedorAgentlessPolicy,
    value: agentPolicy.unenroll_timeout || '',
    min: 0,
    onChange: e => {
      updateAgentPolicy({
        unenroll_timeout: e.target.value ? Number(e.target.value) : 0
      });
    },
    isInvalid: Boolean(touchedFields.unenroll_timeout && validation.unenroll_timeout),
    onBlur: () => setTouchedFields({
      ...touchedFields,
      unenroll_timeout: true
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }));
};
exports.AgentPolicyAdvancedOptionsContent = AgentPolicyAdvancedOptionsContent;