"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMetricsKPIConfig = getMetricsKPIConfig;
var _constants = require("../constants");
var _infra_metrics = require("../constants/field_names/infra_metrics");
var _labels = require("../constants/labels");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getMetricsKPIConfig({
  dataView
}) {
  return {
    reportType: _constants.ReportTypes.KPI,
    defaultSeriesType: 'area',
    seriesTypes: [],
    xAxisColumn: {
      sourceField: '@timestamp'
    },
    yAxisColumns: [{
      sourceField: _constants.REPORT_METRIC_FIELD,
      operationType: 'median'
    }],
    hasOperationType: false,
    filterFields: ['agent.type', 'service.type'],
    breakdownFields: ['agent.hostname', 'service.type'],
    baseFilters: [],
    definitionFields: ['agent.hostname', 'service.type'],
    metricOptions: [{
      label: _labels.SYSTEM_CPU_USAGE,
      field: _infra_metrics.SYSTEM_CPU_PERCENTAGE_FIELD,
      id: _infra_metrics.SYSTEM_CPU_PERCENTAGE_FIELD,
      columnType: _constants.OPERATION_COLUMN
    }, {
      label: _labels.SYSTEM_MEMORY_USAGE,
      field: _infra_metrics.SYSTEM_MEMORY_PERCENTAGE_FIELD,
      id: _infra_metrics.SYSTEM_MEMORY_PERCENTAGE_FIELD,
      columnType: _constants.OPERATION_COLUMN
    }, {
      label: _labels.DOCKER_CPU_USAGE,
      field: _infra_metrics.DOCKER_CPU_PERCENTAGE_FIELD,
      id: _infra_metrics.DOCKER_CPU_PERCENTAGE_FIELD,
      columnType: _constants.OPERATION_COLUMN
    }, {
      label: _labels.K8S_POD_CPU_USAGE,
      field: _infra_metrics.K8S_POD_CPU_PERCENTAGE_FIELD,
      id: _infra_metrics.K8S_POD_CPU_PERCENTAGE_FIELD,
      columnType: _constants.OPERATION_COLUMN
    }],
    labels: {
      ..._constants.FieldLabels
    }
  };
}