"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GitHubViaApp = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _licensing = require("../../../../../shared/licensing");
var _app_logic = require("../../../../app_logic");
var _layout = require("../../../../components/layout");
var _constants = require("../../../../constants");
var _utils = require("../../../../utils");
var _source_data = require("../../source_data");
var _add_source_header = require("./add_source_header");
var _document_permissions_callout = require("./document_permissions_callout");
var _document_permissions_field = require("./document_permissions_field");
var _github_via_app_logic = require("./github_via_app_logic");
var _source_features = require("./source_features");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GitHubViaApp = ({
  isGithubEnterpriseServer
}) => {
  const {
    isOrganization
  } = (0, _kea.useValues)(_app_logic.AppLogic);
  const {
    githubAppId,
    githubEnterpriseServerUrl,
    stagedPrivateKey,
    isSubmitButtonLoading,
    indexPermissionsValue
  } = (0, _kea.useValues)(_github_via_app_logic.GithubViaAppLogic);
  const {
    setGithubAppId,
    setGithubEnterpriseServerUrl,
    setStagedPrivateKey,
    createContentSource,
    setSourceIndexPermissionsValue
  } = (0, _kea.useActions)(_github_via_app_logic.GithubViaAppLogic);
  const {
    hasPlatinumLicense
  } = (0, _kea.useValues)(_licensing.LicensingLogic);
  const name = isGithubEnterpriseServer ? _constants.SOURCE_NAMES.GITHUB_ENTERPRISE : _constants.SOURCE_NAMES.GITHUB;
  const serviceType = isGithubEnterpriseServer ? 'github_enterprise_server' : 'github';
  const data = _source_data.staticSourceData.find(source => source.serviceType === serviceType);
  const Layout = isOrganization ? _layout.WorkplaceSearchPageTemplate : _layout.PersonalDashboardLayout;
  const handleSubmit = e => {
    e.preventDefault();
    createContentSource(isGithubEnterpriseServer);
  };

  // Default indexPermissions to true, if needed
  (0, _react.useEffect)(() => {
    setSourceIndexPermissionsValue(isOrganization && hasPlatinumLicense);
  }, []);
  return /*#__PURE__*/_react.default.createElement(Layout, {
    pageChrome: [_constants.NAV.SOURCES, _constants.NAV.ADD_SOURCE, name || '...'],
    isLoading: false
  }, /*#__PURE__*/_react.default.createElement("form", {
    onSubmit: handleSubmit
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "none",
    hasShadow: false,
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    paddingSize: "l",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_add_source_header.AddSourceHeader, {
    name: name,
    serviceType: "github",
    categories: ['Software', 'Version Control', 'Code Repository'] // TODO: get from API
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    paddingSize: "l",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_source_features.SourceFeatures, {
    features: data.features,
    name: name,
    objTypes: data.objTypes
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), !hasPlatinumLicense && /*#__PURE__*/_react.default.createElement(_document_permissions_callout.DocumentPermissionsCallout, null), hasPlatinumLicense && isOrganization && /*#__PURE__*/_react.default.createElement(_document_permissions_field.DocumentPermissionsField, {
    needsPermissions: true,
    indexPermissionsValue: indexPermissionsValue,
    setValue: setSourceIndexPermissionsValue
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: "GitHub App ID"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: githubAppId,
    onChange: e => setGithubAppId(e.target.value)
  })), isGithubEnterpriseServer && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: "Base URL"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: githubEnterpriseServerUrl,
    onChange: e => setGithubEnterpriseServerUrl(e.target.value)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: "Private key",
    helpText: "Upload private key (.pem) to authenticate GitHub"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilePicker, {
    onChange: files => (0, _utils.handlePrivateKeyUpload)(files, setStagedPrivateKey),
    accept: ".pem"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    type: "submit",
    isLoading: isSubmitButtonLoading,
    isDisabled:
    // disable submit button if any required fields are empty
    !githubAppId || isGithubEnterpriseServer && !githubEnterpriseServerUrl || !stagedPrivateKey
  }, isSubmitButtonLoading ? 'Connecting…' : `Connect ${name}`)));
};
exports.GitHubViaApp = GitHubViaApp;