"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReindexJob = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _i18n = require("@kbn/i18n");
var _schema = require("../../../../shared/schema");
var _routes = require("../../../routes");
var _engine = require("../../engine");
var _layout = require("../../layout");
var _constants = require("../constants");
var _reindex_job_logic = require("./reindex_job_logic");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ReindexJob = () => {
  const {
    reindexJobId
  } = (0, _reactRouterDom.useParams)();
  const {
    loadReindexJob
  } = (0, _kea.useActions)(_reindex_job_logic.ReindexJobLogic);
  const {
    dataLoading,
    fieldCoercionErrors
  } = (0, _kea.useValues)(_reindex_job_logic.ReindexJobLogic);
  const {
    engine: {
      schema
    }
  } = (0, _kea.useValues)(_engine.EngineLogic);
  (0, _react.useEffect)(() => {
    loadReindexJob(reindexJobId);
  }, [reindexJobId]);
  return /*#__PURE__*/_react.default.createElement(_layout.AppSearchPageTemplate, {
    pageChrome: (0, _engine.getEngineBreadcrumbs)([_constants.SCHEMA_TITLE, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.schema.reindexErrorsBreadcrumb', {
      defaultMessage: 'Reindex errors'
    })]),
    pageHeader: {
      pageTitle: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.schema.reindexJob.title', {
        defaultMessage: 'Schema change errors'
      })
    },
    isLoading: dataLoading
  }, /*#__PURE__*/_react.default.createElement(_schema.SchemaErrorsAccordion, {
    fieldCoercionErrors: fieldCoercionErrors,
    schema: schema,
    generateViewPath: documentId => (0, _engine.generateEnginePath)(_routes.ENGINE_DOCUMENT_DETAIL_PATH, {
      documentId
    })
  }));
};
exports.ReindexJob = ReindexJob;