"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldNumber = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const updateOrClearSizeForField = (fieldName, fieldValue, updateAction, clearAction) => {
  if (typeof fieldValue === 'number' && !isNaN(fieldValue)) {
    updateAction(fieldName, fieldValue);
  } else {
    clearAction(fieldName);
  }
};
const handleFieldNumberChange = (fieldName, updateAction, clearAction) => {
  return e => {
    const fieldValue = parseInt(e.target.value, 10);
    updateOrClearSizeForField(fieldName, fieldValue, updateAction, clearAction);
  };
};
const handleFieldNumberBlur = (fieldName, updateAction, clearAction) => {
  return e => {
    let fieldValue = parseInt(e.target.value, 10);
    if (!isNaN(fieldValue)) {
      fieldValue = Math.min(_constants.SIZE_FIELD_MAXIMUM, Math.max(_constants.SIZE_FIELD_MINIMUM, fieldValue));
    }
    updateOrClearSizeForField(fieldName, fieldValue, updateAction, clearAction);
  };
};
const FieldNumber = ({
  fieldSettings,
  fieldName,
  fieldEnabledProperty,
  fieldSizeProperty,
  updateAction,
  clearAction
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    value: typeof fieldSettings[fieldSizeProperty] === 'number' ? fieldSettings[fieldSizeProperty] : ' ' // Without the space, invalid non-numbers don't get cleared for some reason
    ,
    placeholder: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.resultSettings.numberFieldPlaceholder', {
      defaultMessage: 'No limit'
    }),
    disabled: !fieldSettings[fieldEnabledProperty],
    min: _constants.SIZE_FIELD_MINIMUM,
    max: _constants.SIZE_FIELD_MAXIMUM,
    onChange: handleFieldNumberChange(fieldName, updateAction, clearAction),
    onBlur: handleFieldNumberBlur(fieldName, updateAction, clearAction),
    size: 4
  });
};
exports.FieldNumber = FieldNumber;