"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ValidDocumentsSummary = exports.SchemaFieldsSummary = exports.InvalidDocumentsSummary = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _ = require("..");
var _summary_documents = require("./summary_documents");
var _summary_section = require("./summary_section");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const InvalidDocumentsSummary = () => {
  const {
    summary: {
      invalidDocuments
    }
  } = (0, _kea.useValues)(_.DocumentCreationLogic);
  const hasInvalidDocuments = invalidDocuments.total > 0;
  const unshownInvalidDocuments = invalidDocuments.total - invalidDocuments.examples.length;
  return hasInvalidDocuments ? /*#__PURE__*/_react.default.createElement(_summary_section.SummarySectionAccordion, {
    id: "invalidDocuments",
    status: "error",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documentCreation.showSummary.invalidDocuments', {
      defaultMessage: '{invalidDocuments, number} {invalidDocuments, plural, one {document} other {documents}} with errors...',
      values: {
        invalidDocuments: invalidDocuments.total
      }
    })
  }, invalidDocuments.examples.map(({
    document,
    errors
  }, index) => /*#__PURE__*/_react.default.createElement(_summary_documents.ExampleDocumentJson, {
    document: document,
    errors: errors,
    key: index
  })), unshownInvalidDocuments > 0 && /*#__PURE__*/_react.default.createElement(_summary_documents.MoreDocumentsText, {
    documents: unshownInvalidDocuments
  })) : null;
};
exports.InvalidDocumentsSummary = InvalidDocumentsSummary;
const ValidDocumentsSummary = () => {
  const {
    summary: {
      validDocuments
    }
  } = (0, _kea.useValues)(_.DocumentCreationLogic);
  const hasValidDocuments = validDocuments.total > 0;
  const unshownValidDocuments = validDocuments.total - validDocuments.examples.length;
  return hasValidDocuments ? /*#__PURE__*/_react.default.createElement(_summary_section.SummarySectionAccordion, {
    id: "newDocuments",
    status: "success",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documentCreation.showSummary.newDocuments', {
      defaultMessage: 'Added {newDocuments, number} {newDocuments, plural, one {document} other {documents}}.',
      values: {
        newDocuments: validDocuments.total
      }
    })
  }, validDocuments.examples.map((document, index) => /*#__PURE__*/_react.default.createElement(_summary_documents.ExampleDocumentJson, {
    document: document,
    key: index
  })), unshownValidDocuments > 0 && /*#__PURE__*/_react.default.createElement(_summary_documents.MoreDocumentsText, {
    documents: unshownValidDocuments
  })) : /*#__PURE__*/_react.default.createElement(_summary_section.SummarySectionEmpty, {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documentCreation.showSummary.noNewDocuments', {
      defaultMessage: 'No new documents.'
    })
  });
};
exports.ValidDocumentsSummary = ValidDocumentsSummary;
const SchemaFieldsSummary = () => {
  const {
    summary: {
      newSchemaFields
    }
  } = (0, _kea.useValues)(_.DocumentCreationLogic);
  return newSchemaFields.length ? /*#__PURE__*/_react.default.createElement(_summary_section.SummarySectionAccordion, {
    id: "newSchemaFields",
    status: "info",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documentCreation.showSummary.newSchemaFields', {
      defaultMessage: "Added {newFields, number} {newFields, plural, one {field} other {fields}} to the Engine's schema.",
      values: {
        newFields: newSchemaFields.length
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    responsive: false,
    gutterSize: "s"
  }, newSchemaFields.map(schemaField => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: schemaField
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, null, schemaField))))) : /*#__PURE__*/_react.default.createElement(_summary_section.SummarySectionEmpty, {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documentCreation.showSummary.noNewSchemaFields', {
      defaultMessage: 'No new schema fields.'
    })
  });
};
exports.SchemaFieldsSummary = SchemaFieldsSummary;