"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getReasonIfFieldStatsUnavailableForQuery = void 0;
var _esqlUtils = require("@kbn/esql-utils");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getReasonIfFieldStatsUnavailableForQuery = query => {
  if ((0, _esqlUtils.queryCannotBeSampled)(query)) {
    return _i18n.i18n.translate('xpack.dataVisualizer.fieldStats.unavailableForESQLQueryDescription', {
      defaultMessage: `Field statistics are not available for ES|QL queries with 'MATCH' or 'QSTR' functions.`
    });
  }
};
exports.getReasonIfFieldStatsUnavailableForQuery = getReasonIfFieldStatsUnavailableForQuery;