"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ModifiedFieldModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const i18nTexts = {
  title: _i18n.i18n.translate('indexPatternFieldEditor.cancelField.confirmationModal.title', {
    defaultMessage: 'Discard changes'
  }),
  description: _i18n.i18n.translate('indexPatternFieldEditor.cancelField.confirmationModal.description', {
    defaultMessage: `Changes that you've made to your field will be discarded, are you sure you want to continue?`
  }),
  cancelButton: _i18n.i18n.translate('indexPatternFieldEditor.cancelField.confirmationModal.cancelButtonLabel', {
    defaultMessage: 'Cancel'
  })
};
const ModifiedFieldModal = ({
  onCancel,
  onConfirm
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: i18nTexts.title,
    buttonColor: "danger",
    "data-test-subj": "runtimeFieldModifiedFieldConfirmModal",
    cancelButtonText: i18nTexts.cancelButton,
    confirmButtonText: i18nTexts.title,
    onCancel: onCancel,
    onConfirm: onConfirm,
    maxWidth: 600
  }, /*#__PURE__*/_react.default.createElement("p", null, i18nTexts.description));
};
exports.ModifiedFieldModal = ModifiedFieldModal;