"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.typedef2 = exports.typedef1 = exports.typedef = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const typedef = exports.typedef = {
  mappings: {
    properties: {
      foo: {
        type: 'keyword'
      },
      count: {
        type: 'integer'
      }
    }
  },
  schemas: {
    '8.9.0': _configSchema.schema.object({
      foo: _configSchema.schema.string()
    }),
    '8.10.0': _configSchema.schema.object({
      foo: _configSchema.schema.string(),
      count: _configSchema.schema.number()
    })
  },
  switchToModelVersionAt: '8.10.0'
};
const typedef1 = exports.typedef1 = {
  mappings: {
    properties: {
      foo: {
        type: 'keyword'
      },
      count: {
        type: 'integer'
      }
    }
  },
  schemas: {
    '8.9.0': _configSchema.schema.object({
      foo: _configSchema.schema.string()
    }),
    '8.10.0': _configSchema.schema.object({
      foo: _configSchema.schema.string(),
      count: _configSchema.schema.number()
    })
  },
  switchToModelVersionAt: '8.10.0',
  modelVersions: {
    '1': {
      changes: [{
        type: 'mappings_addition',
        addedMappings: {
          count: {
            properties: {
              count: {
                type: 'integer'
              }
            }
          }
        }
      }],
      schemas: {
        create: _configSchema.schema.object({
          foo: _configSchema.schema.string(),
          count: _configSchema.schema.number()
        })
      }
    }
  }
};
const typedef2 = exports.typedef2 = {
  mappings: {
    properties: {
      foo: {
        type: 'keyword'
      },
      count: {
        type: 'integer'
      }
    }
  },
  schemas: {
    '8.9.0': _configSchema.schema.object({
      foo: _configSchema.schema.string()
    })
  },
  switchToModelVersionAt: '8.10.0',
  modelVersions: {
    '1': {
      changes: [{
        type: 'mappings_addition',
        addedMappings: {
          count: {
            properties: {
              count: {
                type: 'integer'
              }
            }
          }
        }
      }],
      schemas: {
        create: _configSchema.schema.object({
          foo: _configSchema.schema.string(),
          count: _configSchema.schema.number()
        })
      }
    }
  }
};