"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTraceSummaryCount = getTraceSummaryCount;
var _common = require("@kbn/observability-plugin/common");
var _server = require("@kbn/observability-plugin/server");
var _apm = require("../../../common/es_fields/apm");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getTraceSummaryCount({
  apmEventClient,
  start,
  end,
  traceId
}) {
  const {
    aggregations,
    hits
  } = await apmEventClient.search('observability_overview_get_service_count', {
    apm: {
      events: [_common.ProcessorEvent.span, _common.ProcessorEvent.transaction]
    },
    body: {
      track_total_hits: true,
      size: 0,
      query: {
        bool: {
          must: [{
            bool: {
              filter: [...(0, _server.termQuery)(_apm.TRACE_ID, traceId), ...(0, _server.rangeQuery)(start, end)]
            }
          }],
          should: [{
            terms: {
              [_apm.PROCESSOR_EVENT]: [_common.ProcessorEvent.span, _common.ProcessorEvent.transaction]
            }
          }, {
            bool: {
              must_not: {
                exists: {
                  field: _apm.PROCESSOR_EVENT
                }
              }
            }
          }],
          minimum_should_match: 1
        }
      },
      aggs: {
        serviceCount: {
          cardinality: {
            field: _apm.SERVICE_NAME
          }
        }
      }
    }
  }, {
    skipProcessorEventFilter: true
  });
  return {
    services: (aggregations === null || aggregations === void 0 ? void 0 : aggregations.serviceCount.value) || 0,
    traceEvents: hits.total.value
  };
}