"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformRRuleToCustomSchedule = void 0;
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _lodash = require("lodash");
var _rrule = require("@kbn/rrule");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformFrequencyToEvery = frequency => {
  switch (frequency) {
    case _rrule.Frequency.YEARLY:
      return 'y';
    case _rrule.Frequency.MONTHLY:
      return 'M';
    case _rrule.Frequency.WEEKLY:
      return 'w';
    case _rrule.Frequency.DAILY:
      return 'd';
    default:
      return;
  }
};
const getDurationInString = duration => {
  const durationInDays = _momentTimezone.default.duration(duration, 'milliseconds').asDays();
  if (durationInDays > 1) {
    return `${durationInDays}d`;
  }
  const durationInHours = _momentTimezone.default.duration(duration, 'milliseconds').asHours();
  if (durationInHours > 1) {
    return `${durationInHours}h`;
  }
  const durationInSeconds = _momentTimezone.default.duration(duration, 'milliseconds').asSeconds();
  if (durationInSeconds % 60 === 0) {
    return `${durationInSeconds / 60}m`;
  }
  return `${durationInSeconds}s`;
};
const transformRRuleToCustomSchedule = snoozeSchedule => {
  const {
    rRule,
    duration
  } = snoozeSchedule;
  const transformedFrequency = transformFrequencyToEvery(rRule.freq);
  const transformedDuration = getDurationInString(duration);
  const recurring = {
    end: rRule.until ? new Date(rRule.until).toISOString() : undefined,
    every: rRule.interval ? `${rRule.interval}${transformedFrequency}` : undefined,
    onWeekDay: rRule.byweekday === null ? undefined : rRule.byweekday,
    onMonthDay: rRule.bymonthday === null ? undefined : rRule.bymonthday,
    onMonth: rRule.bymonth === null ? undefined : rRule.bymonth,
    occurrences: rRule.count
  };
  const filteredRecurring = (0, _lodash.omitBy)(recurring, _lodash.isUndefined);
  return {
    duration: transformedDuration,
    start: new Date(rRule.dtstart).toISOString(),
    timezone: rRule.tzid,
    ...((0, _lodash.isEmpty)(filteredRecurring) ? {} : {
      recurring: filteredRecurring
    })
  };
};
exports.transformRRuleToCustomSchedule = transformRRuleToCustomSchedule;